% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{pathling_read_tables}
\alias{pathling_read_tables}
\title{Create a data source from managed tables}
\usage{
pathling_read_tables(pc, schema = NULL)
}
\arguments{
\item{pc}{The PathlingContext object.}

\item{schema}{An optional schema name that should be used to qualify the table names.}
}
\value{
A DataSource object that can be used to run queries against the data.
}
\description{
\code{pathling_read_tables()} creates a data source from a set of Spark tables,
where the table names are the resource type codes.
}
\examples{
\dontrun{
data_source <- pc \%>\% pathling_read_tables()
data_source \%>\%
  ds_read("Patient") \%>\%
  sparklyr::sdf_nrow()
}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/io#managed-tables}{Pathling documentation - Reading managed tables}

Other data source functions: 
\code{\link{pathling_read_bulk}()},
\code{\link{pathling_read_bundles}()},
\code{\link{pathling_read_datasets}()},
\code{\link{pathling_read_delta}()},
\code{\link{pathling_read_ndjson}()},
\code{\link{pathling_read_parquet}()}
}
\concept{data source functions}
