/*
 * Decompiled with CFR 0.152.
 */
package File;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExperimentFileReader {
    public static ArrayList<AbstractMap.SimpleEntry<String, Double>> readExperimentFile(String path) {
        try {
            String line;
            ArrayList<AbstractMap.SimpleEntry<String, Double>> namePValuePairList = new ArrayList<AbstractMap.SimpleEntry<String, Double>>();
            BufferedReader bufReader = new BufferedReader(new FileReader(path));
            int lineNo = 1;
            while ((line = bufReader.readLine()) != null) {
                String[] strArr = line.split("[ \\t]");
                if (strArr.length == 2) {
                    try {
                        namePValuePairList.add(new AbstractMap.SimpleEntry<String, Double>(strArr[0].toUpperCase(), Double.parseDouble(strArr[1])));
                    }
                    catch (NumberFormatException nfe) {
                        Logger.getLogger(ExperimentFileReader.class.getName()).log(Level.WARNING, "Unexpected number format in experiment file line {0}, discarded", lineNo);
                    }
                } else {
                    Logger.getLogger(ExperimentFileReader.class.getName()).log(Level.WARNING, "Unexpected column number in experiment file line {0}, discarded", lineNo);
                }
                ++lineNo;
            }
            return namePValuePairList;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ExperimentFileReader.class.getName()).log(Level.SEVERE, "Experiment file not found", ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(ExperimentFileReader.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

