% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioclim_vars.R
\docType{methods}
\name{bioclim_vars}
\alias{bioclim_vars}
\alias{bioclim_vars,numeric,numeric-method}
\alias{bioclim_vars,SpatRaster,SpatRaster-method}
\alias{bioclim_vars,SpatRasterDataset,SpatRasterDataset-method}
\alias{bioclim_vars,matrix,matrix-method}
\title{Compute bioclimatic variables}
\usage{
bioclim_vars(prec, tavg, ...)

\S4method{bioclim_vars}{numeric,numeric}(prec, tavg)

\S4method{bioclim_vars}{SpatRaster,SpatRaster}(prec, tavg, filename = "", ...)

\S4method{bioclim_vars}{SpatRasterDataset,SpatRasterDataset}(prec, tavg, filename = "", ...)

\S4method{bioclim_vars}{matrix,matrix}(prec, tavg)
}
\arguments{
\item{prec}{monthly precipitation}

\item{tavg}{monthly average temperatures}

\item{...}{additional variables for specific methods}

\item{filename}{filename where the raster can be stored.}
}
\value{
the bioclim variables
}
\description{
Function to compute "bioclimatic" variables from
monthly average temperature and precipitation data. For modern data,
this variables are generally computed using min and maximum temperature,
but for many palaeoclimatic reconstructions only average temperature is
available. Most variables, with the exception of BIO02 and BIO03, can
be rephrased meaningfully in terms of mean temperature.
This function is a modified version of \code{predicts::bcvars}.
}
\details{
The variables are:
\itemize{
\item BIO01 = Annual Mean Temperature
\item BIO04 = Temperature Seasonality (standard deviation x 100)
\item BIO05 = Max Temperature of Warmest Month
\item BIO06 = Min Temperature of Coldest Month
\item BIO07 = Temperature Annual Range (P5-P6)
\item BIO08 = Mean Temperature of Wettest Quarter
\item BIO09 = Mean Temperature of Driest Quarter
\item BIO10 = Mean Temperature of Warmest Quarter
\item BIO11 = Mean Temperature of Coldest Quarter
\item BIO12 = Annual Precipitation
\item BIO13 = Precipitation of Wettest Month
\item BIO14 = Precipitation of Driest Month
\item BIO15 = Precipitation Seasonality (Coefficient of Variation)
\item BIO16 = Precipitation of Wettest Quarter
\item BIO17 = Precipitation of Driest Quarter
\item BIO18 = Precipitation of Warmest Quarter
\item BIO19 = Precipitation of Coldest Quarter
}

These summary Bioclimatic variables are after:

Nix, 1986. A biogeographic analysis of Australian elapid snakes. In: R. Longmore (ed.).
Atlas of elapid snakes of Australia. Australian Flora and Fauna Series 7.
Australian Government Publishing Service, Canberra.

and expanded following the ANUCLIM manual
}
