% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_mars_earth.R
\name{details_bag_mars_earth}
\alias{details_bag_mars_earth}
\title{Bagged MARS via earth}
\description{
\code{\link[baguette:bagger]{baguette::bagger()}} creates an collection of MARS models forming an
ensemble. All models in the ensemble are combined to produce a final prediction.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{prod_degree}: Degree of Interaction (type: integer, default: 1L)
\item \code{prune_method}: Pruning Method (type: character, default: ‘backward’)
\item \code{num_terms}: # Model Terms (type: integer, default: see below)
}

The default value of \code{num_terms} depends on the number of predictor
columns. For a data frame \code{x}, the default is
\code{min(200, max(20, 2 * ncol(x))) + 1} (see
\code{\link[earth:earth]{earth::earth()}} and the reference below).
}

\subsection{Translation from parsnip to the original package (regression)}{

The \strong{baguette} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{bag_mars(num_terms = integer(1), prod_degree = integer(1), prune_method = character(1)) |> 
  set_engine("earth") |> 
  set_mode("regression") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Bagged MARS Model Specification (regression)
## 
## Main Arguments:
##   num_terms = integer(1)
##   prod_degree = integer(1)
##   prune_method = character(1)
## 
## Computational engine: earth 
## 
## Model fit template:
## baguette::bagger(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), nprune = integer(1), degree = integer(1), 
##     pmethod = character(1), base_model = "MARS")
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (classification)}{

The \strong{baguette} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(baguette)

bag_mars(
  num_terms = integer(1),
  prod_degree = integer(1),
  prune_method = character(1)
) |> 
  set_engine("earth") |> 
  set_mode("classification") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Bagged MARS Model Specification (classification)
## 
## Main Arguments:
##   num_terms = integer(1)
##   prod_degree = integer(1)
##   prune_method = character(1)
## 
## Computational engine: earth 
## 
## Model fit template:
## baguette::bagger(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), nprune = integer(1), degree = integer(1), 
##     pmethod = character(1), base_model = "MARS")
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.

Note that the \code{earth} package documentation has: “In the current
implementation, \emph{building models with weights can be slow}.”
}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("bag_mars_predict") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 3 x 2
##   mode           type   
##   <chr>          <chr>  
## 1 regression     numeric
## 2 classification class  
## 3 classification prob
}\if{html}{\out{</div>}}
}

\subsection{References}{
\itemize{
\item Breiman, L. 1996. “Bagging predictors”. Machine Learning. 24 (2):
123-140
\item Friedman, J. 1991. “Multivariate Adaptive Regression Splines.” \emph{The
Annals of Statistics}, vol. 19, no. 1, pp. 1-67.
\item Milborrow, S. \href{http://www.milbo.org/doc/earth-notes.pdf}{“Notes on the earth package.”}
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
