% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_rbf.R
\name{svm_rbf}
\alias{svm_rbf}
\title{Radial basis function support vector machines}
\usage{
svm_rbf(
  mode = "unknown",
  engine = "kernlab",
  cost = NULL,
  rbf_sigma = NULL,
  margin = NULL
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Possible engines are listed below. The default for this
model is \code{"kernlab"}.}

\item{cost}{A positive number for the cost of predicting a sample within
or on the wrong side of the margin}

\item{rbf_sigma}{A positive number for radial basis function.}

\item{margin}{A positive number for the epsilon in the SVM insensitive
loss function (regression only)}
}
\description{
\code{svm_rbf()} defines a support vector machine model. For classification,
the model tries to maximize the width of the margin between classes using a
nonlinear class boundary. For regression, the model optimizes a robust loss
function that is only affected by very large model residuals and uses
nonlinear functions of the predictors. The function can fit classification
and regression models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("svm_rbf")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.

Each of the arguments in this function other than \code{mode} and \code{engine} are
captured as \link[rlang:topic-quosure]{quosures}. To pass values
programmatically, use the \link[rlang:injection-operator]{injection operator} like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{value <- 1
svm_rbf(argument = !!value)
}\if{html}{\out{</div>}}
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
show_engines("svm_rbf")

svm_rbf(mode = "classification", rbf_sigma = 0.2)
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("svm_rbf")}
}
