% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/required_pkgs.R
\name{required_pkgs.model_spec}
\alias{required_pkgs.model_spec}
\alias{required_pkgs.model_fit}
\title{Determine required packages for a model}
\usage{
\method{required_pkgs}{model_spec}(x, infra = TRUE, ...)

\method{required_pkgs}{model_fit}(x, infra = TRUE, ...)
}
\arguments{
\item{x}{A model specification or fit.}

\item{infra}{Should parsnip itself be included in the result?}

\item{...}{Not used.}
}
\value{
A character vector
}
\description{
Determine required packages for a model
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
should_fail <- try(required_pkgs(linear_reg(engine = NULL)), silent = TRUE)
should_fail

linear_reg() \%>\%
  set_engine("glmnet") \%>\%
  required_pkgs()

linear_reg() \%>\%
  set_engine("glmnet") \%>\%
  required_pkgs(infra = FALSE)

linear_reg() \%>\%
  set_engine("lm") \%>\%
  fit(mpg ~ ., data = mtcars) \%>\%
  required_pkgs()
\dontshow{\}) # examplesIf}
}
