% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree_xgboost.R
\name{details_boost_tree_xgboost}
\alias{details_boost_tree_xgboost}
\title{Boosted trees via xgboost}
\description{
\code{\link[xgboost:xgb.train]{xgboost::xgb.train()}} creates a series of decision trees forming an
ensemble. Each tree depends on the results of previous trees. All trees in
the ensemble are combined to produce a final prediction.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 8 tuning parameters:
\itemize{
\item \code{tree_depth}: Tree Depth (type: integer, default: 6L)
\item \code{trees}: # Trees (type: integer, default: 15L)
\item \code{learn_rate}: Learning Rate (type: double, default: 0.3)
\item \code{mtry}: # Randomly Selected Predictors (type: integer, default: see
below)
\item \code{min_n}: Minimal Node Size (type: integer, default: 1L)
\item \code{loss_reduction}: Minimum Loss Reduction (type: double, default: 0.0)
\item \code{sample_size}: Proportion Observations Sampled (type: double, default:
1.0)
\item \code{stop_iter}: # Iterations Before Stopping (type: integer, default:
Inf)
}

For \code{mtry}, the default value of \code{NULL} translates to using all
available columns.
}

\subsection{Translation from parsnip to the original package (regression)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boost_tree(
  mtry = integer(), trees = integer(), min_n = integer(), tree_depth = integer(),
  learn_rate = numeric(), loss_reduction = numeric(), sample_size = numeric(),
  stop_iter = integer()
) \%>\%
  set_engine("xgboost") \%>\%
  set_mode("regression") \%>\%
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Boosted Tree Model Specification (regression)
## 
## Main Arguments:
##   mtry = integer()
##   trees = integer()
##   min_n = integer()
##   tree_depth = integer()
##   learn_rate = numeric()
##   loss_reduction = numeric()
##   sample_size = numeric()
##   stop_iter = integer()
## 
## Computational engine: xgboost 
## 
## Model fit template:
## parsnip::xgb_train(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     colsample_bynode = integer(), nrounds = integer(), min_child_weight = integer(), 
##     max_depth = integer(), eta = numeric(), gamma = numeric(), 
##     subsample = numeric(), early_stop = integer(), nthread = 1, 
##     verbose = 0)
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boost_tree(
  mtry = integer(), trees = integer(), min_n = integer(), tree_depth = integer(),
  learn_rate = numeric(), loss_reduction = numeric(), sample_size = numeric(),
  stop_iter = integer()
) \%>\% 
  set_engine("xgboost") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Boosted Tree Model Specification (classification)
## 
## Main Arguments:
##   mtry = integer()
##   trees = integer()
##   min_n = integer()
##   tree_depth = integer()
##   learn_rate = numeric()
##   loss_reduction = numeric()
##   sample_size = numeric()
##   stop_iter = integer()
## 
## Computational engine: xgboost 
## 
## Model fit template:
## parsnip::xgb_train(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     colsample_bynode = integer(), nrounds = integer(), min_child_weight = integer(), 
##     max_depth = integer(), eta = numeric(), gamma = numeric(), 
##     subsample = numeric(), early_stop = integer(), nthread = 1, 
##     verbose = 0)
}\if{html}{\out{</div>}}

\code{\link[=xgb_train]{xgb_train()}} is a wrapper around
\code{\link[xgboost:xgb.train]{xgboost::xgb.train()}} (and other functions)
that makes it easier to run this model.
}

\subsection{Preprocessing requirements}{

xgboost does not have a means to translate factor predictors to grouped
splits. Factor/categorical predictors need to be converted to numeric
values (e.g., dummy or indicator variables) for this engine. When using
the formula method via \code{\link[=fit.model_spec]{fit.model_spec()}}, parsnip
will convert factor columns to indicators using a one-hot encoding.

For classification, non-numeric outcomes (i.e., factors) are internally
converted to numeric. For binary classification, the \code{event_level}
argument of \code{set_engine()} can be set to either \code{"first"} or \code{"second"}
to specify which level should be used as the event. This can be helpful
when a watchlist is used to monitor performance from with the xgboost
training process.
}

\subsection{Other details}{
\subsection{Interfacing with the \code{params} argument}{

The xgboost function that parsnip indirectly wraps,
\code{\link[xgboost:xgb.train]{xgboost::xgb.train()}}, takes most arguments via
the \code{params} list argument. To supply engine-specific arguments that are
documented in \code{\link[xgboost:xgb.train]{xgboost::xgb.train()}} as
arguments to be passed via \code{params}, supply the list elements directly
as named arguments to \code{\link[=set_engine]{set_engine()}} rather than as
elements in \code{params}. For example, pass a non-default evaluation metric
like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# good
boost_tree() \%>\%
  set_engine("xgboost", eval_metric = "mae")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Boosted Tree Model Specification (unknown mode)
## 
## Engine-Specific Arguments:
##   eval_metric = mae
## 
## Computational engine: xgboost
}\if{html}{\out{</div>}}

…rather than this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# bad
boost_tree() \%>\%
  set_engine("xgboost", params = list(eval_metric = "mae"))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Boosted Tree Model Specification (unknown mode)
## 
## Engine-Specific Arguments:
##   params = list(eval_metric = "mae")
## 
## Computational engine: xgboost
}\if{html}{\out{</div>}}

parsnip will then route arguments as needed. In the case that arguments
are passed to \code{params} via \code{\link[=set_engine]{set_engine()}}, parsnip will
warn and re-route the arguments as needed. Note, though, that arguments
passed to \code{params} cannot be tuned.
}

\subsection{Sparse matrices}{

xgboost requires the data to be in a sparse format. If your predictor
data are already in this format, then use
\code{\link[=fit_xy.model_spec]{fit_xy.model_spec()}} to pass it to the model
function. Otherwise, parsnip converts the data to this format.
}

\subsection{Parallel processing}{

By default, the model is trained without parallel processing. This can
be change by passing the \code{nthread} parameter to
\code{\link[=set_engine]{set_engine()}}. However, it is unwise to combine this
with external parallel processing when using the package.
}

\subsection{Interpreting \code{mtry}}{

The \code{mtry} argument denotes the number of predictors that will be
randomly sampled at each split when creating tree models.

Some engines, such as \code{"xgboost"}, \code{"xrf"}, and \code{"lightgbm"}, interpret
their analogue to the \code{mtry} argument as the \emph{proportion} of predictors
that will be randomly sampled at each split rather than the \emph{count}. In
some settings, such as when tuning over preprocessors that influence the
number of predictors, this parameterization is quite
helpful—interpreting \code{mtry} as a proportion means that \verb{[0, 1]} is
always a valid range for that parameter, regardless of input data.

parsnip and its extensions accommodate this parameterization using the
\code{counts} argument: a logical indicating whether \code{mtry} should be
interpreted as the number of predictors that will be randomly sampled at
each split. \code{TRUE} indicates that \code{mtry} will be interpreted in its
sense as a count, \code{FALSE} indicates that the argument will be
interpreted in its sense as a proportion.

\code{mtry} is a main model argument for
\code{\link[=boost_tree]{boost_tree()}} and
\code{\link[=rand_forest]{rand_forest()}}, and thus should not have an
engine-specific interface. So, regardless of engine, \code{counts} defaults
to \code{TRUE}. For engines that support the proportion interpretation
(currently \code{"xgboost"} and \code{"xrf"}, via the rules package, and
\code{"lightgbm"} via the bonsai package) the user can pass the
\code{counts = FALSE} argument to \code{set_engine()} to supply \code{mtry} values
within \verb{[0, 1]}.
}

\subsection{Early stopping}{

The \code{stop_iter()} argument allows the model to prematurely stop training
if the objective function does not improve within \code{early_stop}
iterations.

The best way to use this feature is in conjunction with an \emph{internal
validation set}. To do this, pass the \code{validation} parameter of
\code{\link[=xgb_train]{xgb_train()}} via the parsnip
\code{\link[=set_engine]{set_engine()}} function. This is the
proportion of the training set that should be reserved for measuring
performance (and stopping early).

If the model specification has \code{early_stop >= trees}, \code{early_stop} is
converted to \code{trees - 1} and a warning is issued.

Note that, since the \code{validation} argument provides an alternative
interface to \code{watchlist}, the \code{watchlist} argument is guarded by parsnip
and will be ignored (with a warning) if passed.
}

\subsection{Objective function}{

parsnip chooses the objective function based on the characteristics of
the outcome. To use a different loss, pass the \code{objective} argument to
\code{\link[=set_engine]{set_engine()}} directly.
}

}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.

Models fitted with this engine may require native serialization methods
to be properly saved and/or passed between R sessions. To learn more
about preparing fitted models for serialization, see the bundle package.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#boost-tree-xgboost}{examples}
for \code{boost_tree()} with the \code{"xgboost"} engine.
}

\subsection{References}{
\itemize{
\item \href{https://arxiv.org/abs/1603.02754}{XGBoost: A Scalable Tree Boosting System}
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
