% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp_h2o.R
\name{details_mlp_h2o}
\alias{details_mlp_h2o}
\title{Multilayer perceptron via h2o}
\description{
\code{\link[h2o:h2o.deeplearning]{h2o::h2o.deeplearning()}} fits a feed-forward neural network.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 6 tuning parameters:
\itemize{
\item \code{hidden_units}: # Hidden Units (type: integer, default: 200L)
\item \code{penalty}: Amount of Regularization (type: double, default: 0.0)
\item \code{dropout}: Dropout Rate (type: double, default: 0.5)
\item \code{epochs}: # Epochs (type: integer, default: 10)
\item \code{activation}: Activation function (type: character, default: ‘see
below’)
\item \code{learn_rate}: Learning Rate (type: double, default: 0.005)
}

The naming of activation functions in
\code{\link[h2o:h2o.deeplearning]{h2o::h2o.deeplearning()}} differs from
parsnip’s conventions. Currently, only “relu” and “tanh” are supported
and will be converted internally to “Rectifier” and “Tanh” passed to the
fitting function.

\code{penalty} corresponds to l2 penalty.
\code{\link[h2o:h2o.deeplearning]{h2o::h2o.deeplearning()}} also supports
specifying the l1 penalty directly with the engine argument \code{l1}.

Other engine arguments of interest:
\itemize{
\item \code{stopping_rounds} controls early stopping rounds based on the
convergence of another engine parameter \code{stopping_metric}. By
default, \link[h2o:h2o.deeplearning]{h2o::h2o.deeplearning} stops
training if simple moving average of length 5 of the stopping_metric
does not improve for 5 scoring events. This is mostly useful when
used alongside the engine parameter \code{validation}, which is the
\strong{proportion} of train-validation split, parsnip will split and
pass the two data frames to h2o. Then
\link[h2o:h2o.deeplearning]{h2o::h2o.deeplearning} will evaluate the
metric and early stopping criteria on the validation set.
\item h2o uses a 50\% dropout ratio controlled by \code{dropout} for hidden
layers by default.
\code{\link[h2o:h2o.deeplearning]{h2o::h2o.deeplearning()}} provides an
engine argument \code{input_dropout_ratio} for dropout ratios in the
input layer, which defaults to 0.
}
}

\subsection{Translation from parsnip to the original package (regression)}{

\link[agua:h2o_train]{agua::h2o_train_mlp} is a wrapper around
\code{\link[h2o:h2o.deeplearning]{h2o::h2o.deeplearning()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mlp(
  hidden_units = integer(1),
  penalty = double(1),
  dropout = double(1),
  epochs = integer(1),
  learn_rate = double(1),
  activation = character(1)
) \%>\%  
  set_engine("h2o") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Single Layer Neural Network Model Specification (regression)
## 
## Main Arguments:
##   hidden_units = integer(1)
##   penalty = double(1)
##   dropout = double(1)
##   epochs = integer(1)
##   activation = character(1)
##   learn_rate = double(1)
## 
## Computational engine: h2o 
## 
## Model fit template:
## agua::h2o_train_mlp(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     validation_frame = missing_arg(), hidden = integer(1), l2 = double(1), 
##     hidden_dropout_ratios = double(1), epochs = integer(1), activation = character(1), 
##     rate = double(1))
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mlp(
  hidden_units = integer(1),
  penalty = double(1),
  dropout = double(1),
  epochs = integer(1),
  learn_rate = double(1),
  activation = character(1)
) \%>\% 
  set_engine("h2o") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Single Layer Neural Network Model Specification (classification)
## 
## Main Arguments:
##   hidden_units = integer(1)
##   penalty = double(1)
##   dropout = double(1)
##   epochs = integer(1)
##   activation = character(1)
##   learn_rate = double(1)
## 
## Computational engine: h2o 
## 
## Model fit template:
## agua::h2o_train_mlp(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     validation_frame = missing_arg(), hidden = integer(1), l2 = double(1), 
##     hidden_dropout_ratios = double(1), epochs = integer(1), activation = character(1), 
##     rate = double(1))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip
will convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.

By default, \code{\link[h2o:h2o.deeplearning]{h2o::h2o.deeplearning()}} uses
the argument \code{standardize = TRUE} to center and scale all numeric
columns.
}

\subsection{Initializing h2o}{

To use the h2o engine with tidymodels, please run \code{h2o::h2o.init()}
first. By default, This connects R to the local h2o server. This needs
to be done in every new R session. You can also connect to a remote h2o
server with an IP address, for more details see
\code{\link[h2o:h2o.init]{h2o::h2o.init()}}.

You can control the number of threads in the thread pool used by h2o
with the \code{nthreads} argument. By default, it uses all CPUs on the host.
This is different from the usual parallel processing mechanism in
tidymodels for tuning, while tidymodels parallelizes over resamples, h2o
parallelizes over hyperparameter combinations for a given resample.

h2o will automatically shut down the local h2o instance started by R
when R is terminated. To manually stop the h2o server, run
\code{h2o::h2o.shutdown()}.
}
}
\keyword{internal}
