% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree.R
\name{boost_tree}
\alias{boost_tree}
\alias{update.boost_tree}
\title{General Interface for Boosted Trees}
\usage{
boost_tree(mode = "unknown", mtry = NULL, trees = NULL,
  min_n = NULL, tree_depth = NULL, learn_rate = NULL,
  loss_reduction = NULL, sample_size = NULL)

\method{update}{boost_tree}(object, mtry = NULL, trees = NULL,
  min_n = NULL, tree_depth = NULL, learn_rate = NULL,
  loss_reduction = NULL, sample_size = NULL, fresh = FALSE, ...)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{mtry}{An number for the number (or proportion) of predictors that will
be randomly sampled at each split when creating the tree models (\code{xgboost}
only).}

\item{trees}{An integer for the number of trees contained in
the ensemble.}

\item{min_n}{An integer for the minimum number of data points
in a node that are required for the node to be split further.}

\item{tree_depth}{An integer for the maximum deopth of the tree (i.e. number
of splits) (\code{xgboost} only).}

\item{learn_rate}{A number for the rate at which the boosting algorithm adapts
from iteration-to-iteration (\code{xgboost} only).}

\item{loss_reduction}{A number for the reduction in the loss function required
to split further  (\code{xgboost} only).}

\item{sample_size}{An number for the number (or proportion) of data that is
exposed to the fitting routine. For \code{xgboost}, the sampling is done at at
each iteration while \code{C5.0} samples once during traning.}

\item{object}{A boosted tree model specification.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\value{
An updated model specification.
}
\description{
\code{boost_tree()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
different packages in R or via Spark. The main arguments for the
model are:
\itemize{
\item \code{mtry}: The number of predictors that will be
randomly sampled at each split when creating the tree models.
\item \code{trees}: The number of trees contained in the ensemble.
\item \code{min_n}: The minimum number of data points in a node
that are required for the node to be split further.
\item \code{tree_depth}: The maximum depth of the tree (i.e. number of
splits).
\item \code{learn_rate}: The rate at which the boosting algorithm adapts
from iteration-to-iteration.
\item \code{loss_reduction}: The reduction in the loss function required
to split further.
\item \code{sample_size}: The amount of data exposed to the fitting routine.
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using the  \code{set_engine()} function. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions.  If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{boost_tree()}, the
possible modes are "regression" and "classification".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"xgboost"}, \code{"C5.0"}
\item \pkg{Spark}: \code{"spark"}
}
}
\note{
For models created using the spark engine, there are
several differences to consider. First, only the formula
interface to via \code{fit()} is available; using \code{fit_xy()} will
generate an error. Second, the predictions will always be in a
spark table format. The names will be the same as documented but
without the dots. Third, there is no equivalent to factor
columns in spark tables so class predictions are returned as
character columns. Fourth, to retain the model object for a new
R session (via \code{save()}), the \code{model$fit} element of the \code{parsnip}
object should be serialized via \code{ml_save(object$fit)} and
separately saved to disk. In a new session, the object can be
reloaded and reattached to the \code{parsnip} object.
}
\section{Engine Details}{


Engines may have pre-set default arguments when executing the
model fit call.  For this type of model, the template of the
fit calls are:

\pkg{xgboost} classification

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::boost_tree(mode = "classification"), "xgboost")}

\pkg{xgboost} regression

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::boost_tree(mode = "regression"), "xgboost")}

\pkg{C5.0} classification

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::boost_tree(mode = "classification"), "C5.0")}

\pkg{spark} classification

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::boost_tree(mode = "classification"), "spark")}

\pkg{spark} regression

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::boost_tree(mode = "regression"), "spark")}
}

\examples{
boost_tree(mode = "classification", trees = 20)
# Parameters can be represented by a placeholder:
boost_tree(mode = "regression", mtry = varying())
model <- boost_tree(mtry = 10, min_n = 3)
model
update(model, mtry = 1)
update(model, mtry = 1, fresh = TRUE)
}
\seealso{
\code{\link[=varying]{varying()}}, \code{\link[=fit]{fit()}}, \code{\link[=set_engine]{set_engine()}}
}
