% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_source.R
\name{rmd_source}
\alias{rmd_source}
\title{Source the code chunks of an Rmd document}
\usage{
rmd_source(x, local = FALSE, ..., label_comment = TRUE, use_eval = TRUE)
}
\arguments{
\item{x}{An Rmd document (e.g. \code{rmd_ast}, \code{rmd_tibble}, Rmd file path, etc.)}

\item{local}{\code{TRUE}, \code{FALSE} or an environment, determining where the parsed
expressions are evaluated. \code{FALSE} (the default) corresponds to the user's
workspace (the global environment) and \code{TRUE} to the environment from which
source is called.}

\item{...}{Additional arguments passed to \code{\link{source}}.}

\item{label_comment}{Attach chunk labels as comment before each code block.}

\item{use_eval}{Use the \code{eval} chunk option to determine if code is included.}
}
\value{
Returns the result of \code{\link[=source]{source()}} for any R code chunks.
}
\description{
This is the equivalent of the \code{\link[=source]{source()}} function for Rmd files or
their resulting asts.
}
\examples{

rmd_source(system.file("minimal.Rmd", package = "parsermd"), echo=TRUE)

}
