\name{parser}
\Rdversion{1.1}
\alias{parser}
\title{
	Detailed R code parser
}
\description{
	This is a parser for R code using the same grammar 
	as the usual parser (\code{\link{parse}}) but structuring the 
	information differently.
}
\usage{
parser(file, encoding = "unknown", text)
}
\arguments{
  \item{file}{
Source file to parse
}
  \item{encoding}{
Encoding for the file
}
  \item{text}{
If \code{text} is given, then its content is sent to a temporary file,
which is then used as the \code{file} argument.
}
}
\value{
	The output is a list of expressions similar to the 
	output of \code{\link{parse}} except that expressions are not 
	associated with an inline \code{srcref} information. Instead, each 
	expression has an \code{id} attribute that refers to the data. 
	
	The \code{data} attribute is a data frame with the following columns: 
	\item{line1,col1,byte1}{First line, column, and byte of the symbol (token or expression)}
	\item{line2,col2,byte2}{Last line, column, and byte of the symbol (token or expression)}
	\item{token}{Token type.}
	\item{id}{Unique identifier given to this token or expression}
	\item{parent}{identifier for the expression that contains this token or expression}
	\item{token.desc}{A description of this token type. This is read from the 
	output generated by bison}
}
\references{
	This function is largely inspired from the R core \code{\link{parse}} 
	function. The C code uses the same grammar as the one used
	by \code{\link{parse}}. 
	
	The Gnu bison parser generator (\url{http://www.gnu.org/software/bison/})
	is used to create the C code from the grammar.
}

\note{The location information is different to that of R's \code{\link{parse}} function, 
\code{\link{parse}} structures columns and bytes information to 
comply with the \code{\link{substring}} function whereas this function
returns the information as an offset to the start of the line. }

\author{
	Romain Francois <francoisromain@free.fr>
}

\seealso{
	The usual R parser \code{\link{parse}}
}
\examples{	
\dontrun{
tf <- tempfile( ) 
dump( "jitter", file = tf ) 
out <- parser( tf )
data <- attr( out, "data" )
head( data )
unlink(tf)

eval( out )
jitter( 1:10 )
}
	
}
\keyword{ manip }

