% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_pep_table.R
\name{make_pep_table}
\alias{make_pep_table}
\title{Make a data frame of peptides}
\usage{
make_pep_table(msf_file, min_conf = "High",
  prot_regex = "^>([a-zA-Z0-9._]+)\\\\b", collapse = TRUE)
}
\arguments{
\item{msf_file}{A file path to a Thermo MSF file.}

\item{min_conf}{"High", "Medium", or "Low". The mininum peptide confidence level to retrieve from MSF file.}

\item{prot_regex}{Regular expression where the first group matches a protein name or ID from the protein description. Regex must contain ONE group. The protein description is typically generated from a fasta reference file that was used for the database search.}

\item{collapse}{If TRUE, peptides that match to multiple protein sequences are collapsed into a single row with multiple protein descriptions and protein IDs in the \code{Proteins} and \code{ProteinID} columns separated by semi-colons (";").}
}
\value{
A data frame of all peptides above the confidence cut-off from a thermo MSF file.

\item{peptide_id}{a unique peptide ID}
\item{spectrum_id}{a unique spectrum ID}
\item{protein_id}{unique protein group ID to which this peptide maps}
\item{protein_desc}{protein description from reference database used to assign peptides to protein groups, parsed according to \code{prot_regex}}
\item{sequence}{amino acid sequence (does not show post-translational modifications)}
\item{pep_score}{PEP score}
\item{q_value}{Q-value score}
}
\description{
Extracts amino acid sequences (without post-translational modifications), assigned protein groups, and quality scores.
}
\examples{
# Read from a path

make_pep_table(parsemsf_example("test_db.msf"))

# Retrieve full protein description

make_pep_table(parsemsf_example("test_db.msf"), prot_regex = "")

# ...which is also equivalent to...

make_pep_table(parsemsf_example("test_db.msf"), prot_regex = "^(.+)$")

}

