% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_basic.R
\name{\%using\%}
\alias{\%using\%}
\title{Applying a function to the result of a parser}
\usage{
p \%using\% f
}
\arguments{
\item{p}{a parser.}

\item{f}{a function to be applied to the result of a successful \code{p}.}
}
\value{
A parser.
}
\description{
The \verb{\%using\%} combinator allows us to manipulate results from a parser. The
parser \code{(p \%using\% f)} has the same behavior as the parser \code{p}, except that
the function \code{f} is applied to its result value.
}
\section{Pseudocode}{


\preformatted{
(p \%using\% f)(x):
  if p1(x)==[] then fail()(x)
  else succeed(f(p1(x)$L))(x[-1])
}
}

\examples{
(literal("ab") \%using\% toupper)(c("ab", "cdef")) # success
(literal("ab") \%using\% toupper)(c("bb", "cdef")) # failure

}
