% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci.merMod}
\alias{ci.merMod}
\alias{ci.default}
\alias{ci.glm}
\alias{ci.polr}
\alias{ci.mixor}
\alias{ci.DirichletRegModel}
\alias{ci.HLfit}
\alias{ci.glmmTMB}
\alias{ci.zeroinfl}
\alias{ci.hurdle}
\alias{ci.MixMod}
\alias{ci.poissonmfx}
\alias{ci.betamfx}
\alias{ci.betareg}
\alias{ci.clm2}
\alias{ci.lme}
\title{Confidence Intervals (CI)}
\usage{
\method{ci}{merMod}(
  x,
  ci = 0.95,
  method = c("wald", "ml1", "betwithin", "satterthwaite", "kenward", "boot"),
  ...
)

\method{ci}{default}(x, ci = 0.95, method = NULL, ...)

\method{ci}{glm}(x, ci = 0.95, method = c("profile", "wald", "robust"), ...)

\method{ci}{polr}(x, ci = 0.95, method = c("profile", "wald", "robust"), ...)

\method{ci}{mixor}(x, ci = 0.95, effects = c("all", "fixed", "random"), ...)

\method{ci}{DirichletRegModel}(x, ci = 0.95, component = c("all", "conditional", "precision"), ...)

\method{ci}{HLfit}(
  x,
  ci = 0.95,
  method = c("wald", "ml1", "betwithin", "profile", "boot"),
  iterations = 100,
  ...
)

\method{ci}{glmmTMB}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  method = c("wald", "ml1", "betwithin", "robust"),
  verbose = TRUE,
  ...
)

\method{ci}{zeroinfl}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  method = c("wald", "ml1", "betwithin", "robust"),
  verbose = TRUE,
  ...
)

\method{ci}{hurdle}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  method = c("wald", "ml1", "betwithin", "robust"),
  verbose = TRUE,
  ...
)

\method{ci}{MixMod}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "zi", "zero_inflated"),
  verbose = TRUE,
  ...
)

\method{ci}{poissonmfx}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "marginal"),
  method = NULL,
  ...
)

\method{ci}{betamfx}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "precision", "marginal"),
  method = NULL,
  ...
)

\method{ci}{betareg}(x, ci = 0.95, component = c("all", "conditional", "precision"), ...)

\method{ci}{clm2}(x, ci = 0.95, component = c("all", "conditional", "scale"), ...)

\method{ci}{lme}(x, ci = 0.95, method = c("wald", "betwithin", "ml1", "satterthwaite"), ...)
}
\arguments{
\item{x}{A statistical model.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{method}{For mixed models, can be \code{\link[=ci_wald]{"wald"}} (default), \code{\link[=ci_ml1]{"ml1"}} or \code{\link[=ci_betwithin]{"betwithin"}}. For linear mixed model, can also be \code{\link[=ci_satterthwaite]{"satterthwaite"}}, \code{\link[=ci_kenward]{"kenward"}} or \code{"boot"} and \code{lme4::confint.merMod}). For (generalized) linear models, can be \code{"robust"} to compute confidence intervals based on robust covariance matrix estimation, and for generalized linear models, may also be \code{"profile"} (default) or \code{"wald"}.}

\item{...}{Arguments passed down to \code{standard_error_robust()} when confidence intervals or p-values based on robust standard errors should be computed.}

\item{effects}{Should standard errors for fixed effects or random effects
be returned? Only applies to mixed models. May be abbreviated. When
standard errors for random effects are requested, for each grouping factor
a list of standard errors (per group level) for random intercepts and slopes
is returned.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}

\item{iterations}{The number of draws to simulate/bootstrap.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
A data frame containing the CI bounds.
}
\description{
Compute confidence intervals (CI) for frequentist models.
}
\note{
\code{ci_robust()} resp. \code{ci(method = "robust")}
  rely on the \pkg{sandwich} or \pkg{clubSandwich} package (the latter if
  \code{vcov_estimation = "CR"} for cluster-robust standard errors) and will
  thus only work for those models supported by those packages.
}
\examples{
\donttest{
library(parameters)
if (require("glmmTMB")) {
  model <- glmmTMB(
    count ~ spp + mined + (1 | site),
    ziformula = ~mined,
    family = poisson(),
    data = Salamanders
  )

  ci(model)
  ci(model, component = "zi")
}
}
}
