% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetJManyCols}
\alias{GetJManyCols}
\title{GetJManyCols}
\usage{
GetJManyCols(fname, extcols)
}
\arguments{
\item{fname}{String with the file name that contains the binary data.}

\item{extcols}{A numeric vector with the indexes of the columns to be extracted, in R-numbering (from 1)}
}
\value{
A numeric matrix with the values of elements in the requested columns
}
\description{
Returns (as a R numeric matrix) the columns with the requested column numbers from the matrix contained in a jmatrix binary file
}
\examples{
Rf <- matrix(runif(48),nrow=6)
rownames(Rf) <- c("A","B","C","D","E","F")
colnames(Rf) <- c("a","b","c","d","e","f","g","h")
tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
vc<-GetJManyCols(tmpfile1,c(1,4))
vc
}
