% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importMicrobiotaProcess.R
\name{importMicrobiotaProcess}
\alias{importMicrobiotaProcess}
\title{Import MicrobiotaProcess object for PARAFAC modelling}
\usage{
importMicrobiotaProcess(MPobject, subjectIDs, thirdMode, taxa_are_rows = TRUE)
}
\arguments{
\item{MPobject}{MicrobiotaProcess object containing at least an OTU table and sample information, preferably also taxonomic information.}

\item{subjectIDs}{Column name in the sample information corresponding to the subject IDs.}

\item{thirdMode}{Column name in the sample information corresponding to the study design aspect to put in the third mode of the data cube.}

\item{taxa_are_rows}{Boolean specifying if the taxa are in the rows of the OTU table (TRUE) or not (FALSE).}
}
\value{
List object containing:
\itemize{
\item 'data': data cube
\item 'mode1': metadata of the subject mode
\item 'mode2': taxonomy information
\item 'mode3': metadata of the third mode
}
}
\description{
Import MicrobiotaProcess object for PARAFAC modelling
}
\examples{
\dontshow{if (rlang::is_installed("MicrobiotaProcess")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(MicrobiotaProcess)

# Generate synthetic data
sample_info = data.frame(Sample = factor(c("S1", "S2", "S3", "S4", "S5")),
                         time = factor(c("T1", "T2", "T1", "T2", "T1")))
otu_table = matrix(runif(25, min = 0, max = 100), nrow = 5, ncol = 5,
                   dimnames = list(paste0("OTU", 1:5), sample_info$Sample))

taxonomy_table = data.frame(OTU = paste0("OTU", 1:5),
                            Kingdom = rep("King", 5),
                            Phylum = rep("Phy", 5),
                            Class = rep("Cla", 5),
                            Order = rep("Ord", 5),
                            Family = rep("Fam", 5),
                            Genus = rep("Gen", 5))

# Create Summarized Experiment
synthetic_SE = SummarizedExperiment::SummarizedExperiment(
               assays = list(otu = otu_table),
               colData = sample_info,
               rowData = taxonomy_table)

# Convert to MicrobiotaProcess object
synthetic_MPSE = as.MPSE(synthetic_SE)

dataset = importMicrobiotaProcess(synthetic_MPSE,
                                  subjectIDs = "Sample",
                                  thirdMode = "time",
                                  taxa_are_rows = TRUE)
}
\dontshow{\}) # examplesIf}
}
