% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Condition.R
\docType{data}
\name{Condition}
\alias{Condition}
\alias{CondEqual}
\alias{CondAnyOf}
\title{Dependency Condition}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
Condition object, to specify the condition in a dependency.
}
\section{Construction}{
\preformatted{c = Condition$new(type, rhs)
}
\itemize{
\item \code{type} :: \code{character(1)} \cr
Name / type of the condition.
\item \code{rhs::any} \cr
Right-hand-side of the condition.
}
}

\section{Methods}{

\itemize{
\item \code{test(function(x))}\cr
\code{??? -> logical(n)} \cr
Checks if condition is satisfied.
Called on a vector of parent param values.
}
}

\section{Currently implemented simple conditions}{

\itemize{
\item \code{CondEqual$new(rhs)} \cr
Parent must be equal to \code{rhs}.
\item \code{CondAnyOf$new(rhs)} \cr
Parent must be any value of \code{rhs}.
}
}

\keyword{datasets}
