% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_col_row.R
\name{get_dim}
\alias{get_dim}
\alias{get_col}
\alias{get_row}
\title{Get single column or row without dropping names}
\usage{
get_col(matrix, rows, col)

get_row(matrix, row, cols)
}
\arguments{
\item{matrix}{matrix.}

\item{rows}{numeric; rows to subset; like with \code{`[`}, this argument can be left empty to designate all rows.}

\item{col}{integer; single column to subset.}

\item{row}{integer; single row to subset.}

\item{cols}{numeric; columns to subset; like with \code{`[`}, this argument can be left empty to designate all columns.}
}
\value{
A named \code{vector} object.
}
\description{
Subset matrix dropping dimension but without dropping dimname
(as done by \code{`[`} by default).
}
\examples{
m <- matrix(NA,dimnames=list('r1','c1'))
m[1,1] # = NA; R removes both names
get_col(m,rows=1,col=1) # = c(r1=NA) keeps colname
get_row(m,row=1,cols=1) # = c(c1=NA) keeps rowname
}
\author{
Carles \Breto
}
