% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-functions.R
\name{add_hazard}
\alias{add_hazard}
\alias{add_cumu_hazard}
\title{Add predicted (cumulative) hazard to data set}
\usage{
add_hazard(
  newdata,
  object,
  reference = NULL,
  type = c("response", "link"),
  ci = TRUE,
  se_mult = 2,
  ci_type = c("default", "delta", "sim"),
  overwrite = FALSE,
  time_var = NULL,
  ...
)

add_cumu_hazard(
  newdata,
  object,
  ci = TRUE,
  se_mult = 2,
  overwrite = FALSE,
  time_var = NULL,
  interval_length = "intlen",
  ...
)
}
\arguments{
\item{newdata}{ A data frame or list containing the values of the model covariates at which predictions
  are required. If this is not provided then predictions corresponding to the
                original data are returned. If \code{newdata} is provided then
                it should contain all the variables needed for prediction: a
                warning is generated if not. See details for use with \code{link{linear.functional.terms}}. }

\item{object}{ a fitted \code{gam} object as produced by \code{gam()}.
                }

\item{reference}{A data frame with number of rows equal to \code{nrow(newdata)} or
one, or a named list with (partial) covariate specifications. See examples.}

\item{type}{Either \code{"response"} or \code{"link"}. The former calculates
hazard, the latter the log-hazard.}

\item{ci}{\code{logical}. Indicates if confidence intervals should be
calculated. Defaults to \code{TRUE}.}

\item{se_mult}{Factor by which standard errors are multiplied for calculating
the confidence intervals.}

\item{ci_type}{The method by which standard errors/confidence intervals
will be calculated. Default transforms the linear predictor at
respective intervals. \code{"delta"} calculates CIs based on the standard
error calculated by the Delta method. \code{"sim"} draws the
property of interest from its posterior based on the normal distribution of
the estimated coefficients. See \href{https://adibender.github.io/simpamm/confidence-intervals.html}{here}
for details and empirical evaluation.}

\item{overwrite}{Should hazard columns be overwritten if already present in
the data set? Defaults to \code{FALSE}. If \code{TRUE}, columns with names
\code{c("hazard", "se", "lower", "upper")} will be overwritten.}

\item{time_var}{Name of the variable used for the baseline hazard. If
not given, defaults to \code{"tend"} for \code{\link[mgcv]{gam}} fits, else
\code{"interval"}. The latter is assumed to be a factor, the former
numeric.}

\item{...}{Further arguments passed to \code{\link[mgcv]{predict.gam}} and
\code{\link{get_hazard}}}

\item{interval_length}{The variable in newdata containing the interval lengths.
Can be either bare unquoted variable name or character. Defaults to \code{"intlen"}.}
}
\description{
Add (cumulative) hazard based on the provided data set and model.
If \code{ci=TRUE} confidence intervals (CI) are also added. Their width can
be controlled via the \code{se_mult} argument. The method by which the
CI are calculated can be specified by \code{ci_type}.
This is a wrapper around
\code{\link[mgcv]{predict.gam}}. When \code{reference} is specified, the
(log-)hazard ratio is calculated.
}
\examples{
ped <- tumor[1:50,] \%>\% as_ped(Surv(days, status)~ age)
pam <- mgcv::gam(ped_status ~ s(tend)+age, data = ped, family=poisson(), offset=offset)
ped_info(ped) \%>\% add_hazard(pam, type="link")
ped_info(ped) \%>\% add_hazard(pam, type = "response")
ped_info(ped) \%>\% add_cumu_hazard(pam)
}
\seealso{
\code{\link[mgcv]{predict.gam}},
\code{\link[pammtools]{add_surv_prob}}
}
