test_that("read_dual_pam_data 20240925.csv - default", {
  test_data_file <- file.path(getwd(), "data", "20240925.csv")
  data <- read_dual_pam_data(test_data_file)

  par <- data$par
  expect_equal(par[1], 0)
  expect_equal(par[2], 40)
  expect_equal(par[3], 49)
  expect_equal(par[4], 62)
  expect_equal(par[5], 86)
  expect_equal(par[6], 112)
  expect_equal(par[7], 141)
  expect_equal(par[8], 183)
  expect_equal(par[9], 237)
  expect_equal(par[10], 306)
  expect_equal(par[11], 391)
  expect_equal(par[12], 489)
  expect_equal(par[13], 603)
  expect_equal(par[14], 756)
  expect_equal(par[15], 928)
  expect_equal(par[16], 1144)
  expect_equal(par[17], 1420)

  yield_1 <- data$yield_1
  expect_equal(yield_1[1], 0.465)
  expect_equal(yield_1[2], 0.783)
  expect_equal(yield_1[3], 0.783)
  expect_equal(yield_1[4], 0.756)
  expect_equal(yield_1[5], 0.76)
  expect_equal(yield_1[6], 0.754)
  expect_equal(yield_1[7], 0.695)
  expect_equal(yield_1[8], 0.68)
  expect_equal(yield_1[9], 0.68)
  expect_equal(yield_1[10], 0.64)
  expect_equal(yield_1[11], 0.594)
  expect_equal(yield_1[12], 0.534)
  expect_equal(yield_1[13], 0.485)
  expect_equal(yield_1[14], 0.426)
  expect_equal(yield_1[15], 0.358)
  expect_equal(yield_1[16], 0.321)
  expect_equal(yield_1[17], 0.253)

  yield_2 <- data$yield_2
  expect_equal(yield_2[1], 0.548)
  expect_equal(yield_2[2], 0.342)
  expect_equal(yield_2[3], 0.336)
  expect_equal(yield_2[4], 0.342)
  expect_equal(yield_2[5], 0.34)
  expect_equal(yield_2[6], 0.333)
  expect_equal(yield_2[7], 0.328)
  expect_equal(yield_2[8], 0.321)
  expect_equal(yield_2[9], 0.303)
  expect_equal(yield_2[10], 0.273)
  expect_equal(yield_2[11], 0.238)
  expect_equal(yield_2[12], 0.203)
  expect_equal(yield_2[13], 0.172)
  expect_equal(yield_2[14], 0.138)
  expect_equal(yield_2[15], 0.11)
  expect_equal(yield_2[16], 0.087)
  expect_equal(yield_2[17], 0.065)

  etr_1 <- data$etr_1
  expect_equal(etr_1[1], 0)
  expect_equal(etr_1[2], 13.1544)
  expect_equal(etr_1[3], 16.11414)
  expect_equal(etr_1[4], 19.68624)
  expect_equal(etr_1[5], 27.4512)
  expect_equal(etr_1[6], 35.46816)
  expect_equal(etr_1[7], 41.1579)
  expect_equal(etr_1[8], 52.2648)
  expect_equal(etr_1[9], 67.6872)
  expect_equal(etr_1[10], 82.2528)
  expect_equal(etr_1[11], 97.54668)
  expect_equal(etr_1[12], 109.67292)
  expect_equal(etr_1[13], 122.8311)
  expect_equal(etr_1[14], 135.26352)
  expect_equal(etr_1[15], 139.53408)
  expect_equal(etr_1[16], 154.23408)
  expect_equal(etr_1[17], 150.8892)

  etr_2 <- data$etr_2
  expect_equal(etr_2[1], 0)
  expect_equal(etr_2[2], 5.7456)
  expect_equal(etr_2[3], 6.91488)
  expect_equal(etr_2[4], 8.90568)
  expect_equal(etr_2[5], 12.2808)
  expect_equal(etr_2[6], 15.66432)
  expect_equal(etr_2[7], 19.42416)
  expect_equal(etr_2[8], 24.67206)
  expect_equal(etr_2[9], 30.16062)
  expect_equal(etr_2[10], 35.08596)
  expect_equal(etr_2[11], 39.08436)
  expect_equal(etr_2[12], 41.69214)
  expect_equal(etr_2[13], 43.56072)
  expect_equal(etr_2[14], 43.81776)
  expect_equal(etr_2[15], 42.8736)
  expect_equal(etr_2[16], 41.80176)
  expect_equal(etr_2[17], 38.766)
})

test_that("read_dual_pam_data 20240925.csv - etr_factor 0.5", {
  test_data_file <- file.path(getwd(), "data", "20240925.csv")
  data <- read_dual_pam_data(test_data_file, etr_factor = 0.5)

  par <- data$par
  expect_equal(par[1], 0)
  expect_equal(par[2], 40)
  expect_equal(par[3], 49)
  expect_equal(par[4], 62)
  expect_equal(par[5], 86)
  expect_equal(par[6], 112)
  expect_equal(par[7], 141)
  expect_equal(par[8], 183)
  expect_equal(par[9], 237)
  expect_equal(par[10], 306)
  expect_equal(par[11], 391)
  expect_equal(par[12], 489)
  expect_equal(par[13], 603)
  expect_equal(par[14], 756)
  expect_equal(par[15], 928)
  expect_equal(par[16], 1144)
  expect_equal(par[17], 1420)

  yield_1 <- data$yield_1
  expect_equal(yield_1[1], 0.465)
  expect_equal(yield_1[2], 0.783)
  expect_equal(yield_1[3], 0.783)
  expect_equal(yield_1[4], 0.756)
  expect_equal(yield_1[5], 0.76)
  expect_equal(yield_1[6], 0.754)
  expect_equal(yield_1[7], 0.695)
  expect_equal(yield_1[8], 0.68)
  expect_equal(yield_1[9], 0.68)
  expect_equal(yield_1[10], 0.64)
  expect_equal(yield_1[11], 0.594)
  expect_equal(yield_1[12], 0.534)
  expect_equal(yield_1[13], 0.485)
  expect_equal(yield_1[14], 0.426)
  expect_equal(yield_1[15], 0.358)
  expect_equal(yield_1[16], 0.321)
  expect_equal(yield_1[17], 0.253)

  yield_2 <- data$yield_2
  expect_equal(yield_2[1], 0.548)
  expect_equal(yield_2[2], 0.342)
  expect_equal(yield_2[3], 0.336)
  expect_equal(yield_2[4], 0.342)
  expect_equal(yield_2[5], 0.34)
  expect_equal(yield_2[6], 0.333)
  expect_equal(yield_2[7], 0.328)
  expect_equal(yield_2[8], 0.321)
  expect_equal(yield_2[9], 0.303)
  expect_equal(yield_2[10], 0.273)
  expect_equal(yield_2[11], 0.238)
  expect_equal(yield_2[12], 0.203)
  expect_equal(yield_2[13], 0.172)
  expect_equal(yield_2[14], 0.138)
  expect_equal(yield_2[15], 0.11)
  expect_equal(yield_2[16], 0.087)
  expect_equal(yield_2[17], 0.065)

  etr_1 <- data$etr_1
  expect_equal(etr_1[1], 0)
  expect_equal(etr_1[2], 7.83)
  expect_equal(etr_1[3], 9.59175)
  expect_equal(etr_1[4], 11.718)
  expect_equal(etr_1[5], 16.34)
  expect_equal(etr_1[6], 21.112)
  expect_equal(etr_1[7], 24.49875)
  expect_equal(etr_1[8], 31.11)
  expect_equal(etr_1[9], 40.29)
  expect_equal(etr_1[10], 48.96)
  expect_equal(etr_1[11], 58.0635)
  expect_equal(etr_1[12], 65.2815)
  expect_equal(etr_1[13], 73.11375)
  expect_equal(etr_1[14], 80.514)
  expect_equal(etr_1[15], 83.056)
  expect_equal(etr_1[16], 91.806)
  expect_equal(etr_1[17], 89.815)

  etr_2 <- data$etr_2
  expect_equal(etr_2[1], 0)
  expect_equal(etr_2[2], 3.42)
  expect_equal(etr_2[3], 4.116)
  expect_equal(etr_2[4], 5.301)
  expect_equal(etr_2[5], 7.31)
  expect_equal(etr_2[6], 9.324)
  expect_equal(etr_2[7], 11.562)
  expect_equal(etr_2[8], 14.68575)
  expect_equal(etr_2[9], 17.95275)
  expect_equal(etr_2[10], 20.8845)
  expect_equal(etr_2[11], 23.2645)
  expect_equal(etr_2[12], 24.81675)
  expect_equal(etr_2[13], 25.929)
  expect_equal(etr_2[14], 26.082)
  expect_equal(etr_2[15], 25.52)
  expect_equal(etr_2[16], 24.882)
  expect_equal(etr_2[17], 23.075)
})

test_that("read_dual_pam_data 20240925.csv - fraction_photosystem > 1", {
  test_data_file <- file.path(getwd(), "data", "20240925.csv")

  expect_error(read_dual_pam_data(test_data_file, fraction_photosystem_I = 0.9, fraction_photosystem_II = 0.2))
})

test_that("read_dual_pam_data 20240925.csv - fraction_photosystem_I = 0.2, fraction_photosystem_II = 0.8", {
  test_data_file <- file.path(getwd(), "data", "20240925.csv")
  data <- read_dual_pam_data(test_data_file, fraction_photosystem_I = 0.2, fraction_photosystem_II = 0.8)

  par <- data$par
  expect_equal(par[1], 0)
  expect_equal(par[2], 40)
  expect_equal(par[3], 49)
  expect_equal(par[4], 62)
  expect_equal(par[5], 86)
  expect_equal(par[6], 112)
  expect_equal(par[7], 141)
  expect_equal(par[8], 183)
  expect_equal(par[9], 237)
  expect_equal(par[10], 306)
  expect_equal(par[11], 391)
  expect_equal(par[12], 489)
  expect_equal(par[13], 603)
  expect_equal(par[14], 756)
  expect_equal(par[15], 928)
  expect_equal(par[16], 1144)
  expect_equal(par[17], 1420)

  yield_1 <- data$yield_1
  expect_equal(yield_1[1], 0.465)
  expect_equal(yield_1[2], 0.783)
  expect_equal(yield_1[3], 0.783)
  expect_equal(yield_1[4], 0.756)
  expect_equal(yield_1[5], 0.76)
  expect_equal(yield_1[6], 0.754)
  expect_equal(yield_1[7], 0.695)
  expect_equal(yield_1[8], 0.68)
  expect_equal(yield_1[9], 0.68)
  expect_equal(yield_1[10], 0.64)
  expect_equal(yield_1[11], 0.594)
  expect_equal(yield_1[12], 0.534)
  expect_equal(yield_1[13], 0.485)
  expect_equal(yield_1[14], 0.426)
  expect_equal(yield_1[15], 0.358)
  expect_equal(yield_1[16], 0.321)
  expect_equal(yield_1[17], 0.253)

  yield_2 <- data$yield_2
  expect_equal(yield_2[1], 0.548)
  expect_equal(yield_2[2], 0.342)
  expect_equal(yield_2[3], 0.336)
  expect_equal(yield_2[4], 0.342)
  expect_equal(yield_2[5], 0.34)
  expect_equal(yield_2[6], 0.333)
  expect_equal(yield_2[7], 0.328)
  expect_equal(yield_2[8], 0.321)
  expect_equal(yield_2[9], 0.303)
  expect_equal(yield_2[10], 0.273)
  expect_equal(yield_2[11], 0.238)
  expect_equal(yield_2[12], 0.203)
  expect_equal(yield_2[13], 0.172)
  expect_equal(yield_2[14], 0.138)
  expect_equal(yield_2[15], 0.11)
  expect_equal(yield_2[16], 0.087)
  expect_equal(yield_2[17], 0.065)

  etr_1 <- data$etr_1
  expect_equal(etr_1[1], 0)
  expect_equal(etr_1[2], 5.26176)
  expect_equal(etr_1[3], 6.445656)
  expect_equal(etr_1[4], 7.874496)
  expect_equal(etr_1[5], 10.98048)
  expect_equal(etr_1[6], 14.187264)
  expect_equal(etr_1[7], 16.46316)
  expect_equal(etr_1[8], 20.90592)
  expect_equal(etr_1[9], 27.07488)
  expect_equal(etr_1[10], 32.90112)
  expect_equal(etr_1[11], 39.018672)
  expect_equal(etr_1[12], 43.869168)
  expect_equal(etr_1[13], 49.13244)
  expect_equal(etr_1[14], 54.105408)
  expect_equal(etr_1[15], 55.813632)
  expect_equal(etr_1[16], 61.693632)
  expect_equal(etr_1[17], 60.35568)

  etr_2 <- data$etr_2
  expect_equal(etr_2[1], 0)
  expect_equal(etr_2[2], 9.19296)
  expect_equal(etr_2[3], 11.0638080)
  expect_equal(etr_2[4], 14.2490880)
  expect_equal(etr_2[5], 19.64928)
  expect_equal(etr_2[6], 25.0629120)
  expect_equal(etr_2[7], 31.0786560)
  expect_equal(etr_2[8], 39.4752960)
  expect_equal(etr_2[9], 48.2569920)
  expect_equal(etr_2[10], 56.1375360)
  expect_equal(etr_2[11], 62.5349760)
  expect_equal(etr_2[12], 66.7074240)
  expect_equal(etr_2[13], 69.6971520)
  expect_equal(etr_2[14], 70.1084160)
  expect_equal(etr_2[15], 68.59776)
  expect_equal(etr_2[16], 66.8828160)
  expect_equal(etr_2[17], 62.0256)
})

test_that("20260130_01_efeutute_dual_pam_only_ps_1.csv - expect fm missing", {
  test_data_file <- file.path(getwd(), "data", "20260130_01_efeutute_dual_pam_only_ps_1.csv")
  expect_error(read_dual_pam_data(test_data_file))
})

test_that("20260130_efeutute_dual_pam_only_ps_2.csv - expect pm missing", {
  test_data_file <- file.path(getwd(), "data", "20260130_efeutute_dual_pam_only_ps_2.csv")
  expect_error(read_dual_pam_data(test_data_file))
})