% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-ns.r
\name{fit.void}
\alias{fit.void}
\title{Fitting a model to a void point process}
\usage{
fit.void(points, lims, R, edge.correction = "pbc", start = NULL, bounds,
  trace = FALSE)
}
\arguments{
\item{points}{A matrix containing locations of observed points,
where each row corresponds to a point and each column
corresponds to a dimension.}

\item{lims}{A matrix with two columns, corresponding to the upper
and lower limits of each dimension, respectively.}

\item{R}{Truncation distance for the difference process.}

\item{edge.correction}{The method used for the correction of edge
effects. Either \code{"pbc"} for periodic boundary conditions,
or \code{"buffer"} for a buffer-zone correction.}

\item{start}{A named vector of starting values for the model
parameters.}

\item{bounds}{A list with named components. Each component should
be a vector of length two, giving the upper and lower bounds
for the named parameter.}

\item{trace}{Logical; if \code{TRUE}, parameter values are printed
to the screen for each iteration of the optimisation procedure.}
}
\value{
An R6 reference class object. Extraction of the information
    held within is best handled by functions \link{coef.palm},
    \link{confint.palm}, \link{summary.palm}, and \link{plot.palm}.
}
\description{
Estimates parameters for a void point process by maximising the
Palm likelihood. This approach was first proposed by Tanaka et
al. (2008) for two-dimensional Thomas processes. Generalisation to
d-dimensional void processes was made by Jones-Todd (2017).
}
\details{
Parameters to estimate are as follows:
\itemize{
  \item \code{Dc}, the baseline density of observed points.

\item \code{Dp}, the density of unobserved parents that cause voids.

\item \code{tau}, the radius of the deletion process centred at each parent.
}
}
\references{
Tanaka, U., Ogata, Y., and Stoyan, D. (2008) Parameter
    estimation and model selection for Neyman-Scott point
    processes. \emph{Biometrical Journal}, \strong{50}: 43--57.

Jones-Todd, C. M. (2017) \emph{Modelling complex
    dependencies inherent in spatial and spatio-temporal point
    pattern data}. PhD thesis, University of St Andrews.
}

