test_that("simFossilRecord doesn't produce negative dates", {

library(paleotree)

saved_seed <- c(
10403L, 571L, -1853698735L, -1617683795L, 1433983323L, 1602013699L, 
-2139602443L, 828740635L, 810136674L, -222442686L, -1062350433L, 
-279344709L, -2137247395L, -966848151L, -488751592L, -1706372736L, 
-462208098L, 2108738791L, 1854509369L, -1307471181L, 1824146925L, 
1513717001L, 275256421L, -1846634309L, -833859483L, -734561029L, 
1042021435L, 809711929L, 419243244L, -802286761L, 1497007147L, 
81557787L, -660252751L, -97986758L, -1448549103L, -1958553833L, 
2138156950L, 1516137314L, -1055500571L, 1731328840L, -224850824L, 
578689076L, 75625678L, -1737530033L, -1970920588L, 655890861L, 
1915360703L, -2005923087L, 465893075L, -987497959L, -1961535427L, 
-1630816780L, -2054701103L, 1923176537L, -615338329L, 903476606L, 
1020325941L, -1477321166L, 1366880540L, 461923545L, 911670059L, 
456674787L, 1757261593L, -214157451L, 23884317L, -61834478L, 
-1284939658L, 60821190L, 1290224258L, 1637433497L, 1829748002L, 
-1496828380L, -1589954927L, -431184785L, -98000072L, 1734108228L, 
-1060726931L, 1424209627L, -492293930L, 1827255675L, -1515697483L, 
1705432642L, -654919731L, 479249862L, -642548399L, 463517046L, 
1437299327L, -661009978L, -545419484L, 1095205387L, 1204985906L, 
60112567L, 747657768L, 1363495870L, -619584692L, -669186361L, 
852912097L, 665320879L, -671271289L, 1086304910L, -2071286025L, 
-1383204603L, -2113284666L, 1775147647L, -1408585778L, 2079737639L, 
615561733L, 73689641L, 1337836445L, -122174301L, 706428174L, 
1602647067L, 124432173L, 1689693158L, 29308779L, -1124538333L, 
298880120L, -1649708682L, -955015679L, 1315162081L, -462518049L, 
2013666168L, 696045019L, 390286924L, 1076310877L, -1361451743L, 
-1665344435L, 1837707039L, 163101988L, 1829851039L, -2066823469L, 
-90204041L, 1814667675L, -457052526L, 123341287L, 463472256L, 
-1430167168L, 301112184L, 1723064924L, -1159489234L, 1076843039L, 
-1132661112L, 27798743L, -1975550119L, -1008435513L, -1504805619L, 
-1676524544L, -354669894L, 1138748432L, -561934610L, 1914366784L, 
-1982489914L, -1357599160L, -1938070906L, -1806154290L, -1094073373L, 
2087859816L, 1110103573L, 2025907443L, -379404128L, -1174067044L, 
-1267612669L, 1573604445L, 1001623553L, -135456734L, -1575261349L, 
-1815750733L, -1018860996L, -436036596L, -2138189894L, 250540748L, 
910620079L, 297999721L, -787324315L, 607555736L, -11846095L, 
-1836666190L, 2000222791L, -155347258L, 88808049L, 508040486L, 
-448013317L, -211033215L, 2042103042L, 1649670458L, 2045553063L, 
-16545087L, -1668583180L, 1946719758L, 781884963L, 696941254L, 
919544888L, 1471648712L, 549978839L, 1889953923L, 1640331206L, 
-1764565144L, 277868371L, 1655843748L, -1949612026L, 1993309602L, 
-1700497328L, 846105420L, -709770589L, 1802532037L, -1608245964L, 
474706330L, -1589153638L, -698466802L, -1990683508L, -1648915059L, 
-518663001L, -1056118794L, 424234687L, 856322830L, -1258942958L, 
869424139L, -445077723L, -973033739L, 1276005716L, -247957612L, 
1239547611L, 1574788792L, -854735167L, 1289734935L, 852943523L, 
1296864790L, -133808582L, -216284195L, 879457686L, -1377906328L, 
1597715383L, -1765177183L, 482511652L, -1211171858L, -1672126265L, 
533761940L, -736680301L, -1584136012L, -2058234427L, 1122491067L, 
-1312521127L, -1322337215L, -797826844L, -36248282L, -432167968L, 
-1542279032L, -2078621936L, 1483903132L, -2146889202L, 231610347L, 
2141070295L, 1129857719L, -1062243101L, 1500707757L, -2086555059L, 
-492347650L, -1756441812L, -799029007L, 643260017L, 1081037763L, 
-995194269L, -744808703L, -300509415L, 805434156L, 1417125810L, 
1688950459L, -647830294L, -318983034L, 1472091132L, 1284145290L, 
438409963L, 1039086804L, -1329068550L, 1475391745L, 743261523L, 
1844477472L, -948242021L, 2051359923L, 1853483022L, -602159388L, 
-200059860L, 1966119739L, 2094190721L, -1852317829L, 530993408L, 
-1476986008L, -847875145L, 909813623L, -1439558460L, 1411827320L, 
349167711L, 172282929L, 1644103834L, -590876338L, 1223027271L, 
-537116176L, -1210458223L, 1908648705L, 1394227509L, -74821458L, 
2087266771L, 47978638L, 792460695L, -1265557208L, -80134366L, 
1232891816L, 1611714571L, 1020846137L, 773016345L, 1617766307L, 
-1235879317L, 1895391305L, 169233468L, -1258775487L, -1461443236L, 
-1906564258L, -933806533L, -1461390823L, 1916731630L, -731894006L, 
1922128305L, -1294909155L, -1490264410L, -1433634674L, -132189123L, 
-633352314L, 1217080486L, 1278041233L, 160642529L, 2055737957L, 
-2035578178L, 498491404L, 1860733850L, -1545521305L, 673391474L, 
-1944192042L, -762553878L, -1336312142L, 1232118406L, 1955124317L, 
-1870118377L, -1127308999L, -172897011L, -1224248334L, -1776683384L, 
-922118073L, -49032017L, 1692435451L, -857936441L, -1769584363L, 
-1475906502L, -1496298326L, 270862639L, 940687450L, -1326161823L, 
2062695569L, 436014856L, -1803713131L, -424225252L, 797426765L, 
393691671L, -673601349L, 531454110L, -1225646598L, -235716991L, 
-1865330947L, 1263335694L, -1264999834L, -670156227L, 196235768L, 
426497556L, -1369999781L, -522140111L, 1592919051L, 1639184800L, 
1012881521L, 1138772221L, 424715353L, 666399614L, 974715248L, 
-712772579L, -661399666L, 2002771233L, -425412621L, 1304477587L, 
-1742662538L, -869915638L, -1383823571L, -860162588L, 163863576L, 
-1683806652L, 1091419704L, -775859408L, -62549785L, -162207709L, 
-353924515L, 620454336L, -1245118640L, 1905653577L, 636261242L, 
-1596437293L, 16449432L, -1691767447L, 1348172727L, -1384311936L, 
1125393544L, -2072848942L, 713008419L, 742054253L, -1476661401L, 
843793876L, -1284451103L, 1221778685L, 902272468L, -218093693L, 
1597593062L, -1323665945L, -1641685136L, 2096268918L, -1151974505L, 
-1966507230L, -2142822395L, 1365160752L, 1562929423L, -971159986L, 
982929974L, -943681632L, -655961415L, -1113726106L, 821777900L, 
-1936930352L, 1658389807L, -1480587857L, 1810373062L, 1610187420L, 
-1061552600L, 1845170423L, 1659752482L, 1977364133L, -2067258745L, 
1988951973L, -2014122681L, -1542221550L, -1160666994L, -905249898L, 
-1350605932L, 297765417L, -427768077L, -1468684165L, 884615840L, 
-2061673235L, 1844719662L, -1158590253L, -1572328378L, -640196980L, 
919524830L, -577017372L, 1257573538L, -556445104L, 1271285357L, 
21657835L, 1194448631L, -1270375187L, 1227184612L, -697506L, 
-750946175L, 936751255L, 487023160L, 1339140426L, 1129432116L, 
745934588L, 827759462L, 1487497420L, -730778558L, -1676435491L, 
-808592782L, -285203312L, -166055190L, 1501951550L, 66472998L, 
-589611882L, 1998712821L, -308880320L, 1242288438L, 2060022343L, 
998675296L, -953336964L, 1036916920L, -290148209L, -850088204L, 
1053428966L, 424423530L, 1220326178L, 456053541L, 61604734L, 
-1953344484L, 619188727L, 440896579L, -2013706738L, -2043450736L, 
-84513113L, 1237269073L, -594001374L, 1018541669L, 122526729L, 
1762858799L, 609160311L, 141995178L, 224443233L, -1020010147L, 
192517030L, -2090136902L, -1491007030L, -456193341L, -1415919708L, 
1073127930L, -514912680L, 1815086148L, -12998123L, -1480420701L, 
387063727L, 1636959551L, -2128380953L, -395012474L, 1840629665L, 
936331776L, -424264728L, -181232011L, 1523099133L, -1473420234L, 
-1722394862L, -1188569071L, -1822663880L, 455731667L, -1116163407L, 
-1184463873L, 709462160L, -102575007L, 2023507857L, -1152626809L, 
1507025682L, -1810804074L, 754430500L, 1253840337L, -1283465938L, 
1909853053L, -517508315L, 1385022721L, -130431013L, 823102562L, 
-483524280L, -1176901917L, 2026469711L, -680898713L, 948804489L, 
-513523886L, 388724366L, -1732770673L, -1824387128L, -797827748L, 
1942468467L, -1305606244L, -1706830508L, 1795512931L, -934665508L, 
1981531473L, 1457743656L, 836767629L, -123389583L, 1415885779L, 
745320262L, 599784800L, -857165284L, -1164506705L, 1234223610L, 
21605988L, -675791210L, -1216791157L, -692101884L, 660234683L, 
1803226399L, -683833859L, 35139070L, -639158710L, 13069439L, 
-1617037945L, 1582373318L, -567721642L, 2090187424L, 890488569L, 
-978532023L, 1145450893L, 530946503L, -1357110337L, -1119543141L, 
1864871195L, -212985630L, 1132921875L, -581074538L, 1040283510L, 
1232269288L, 858962061L, 496032078L, -1700434939L, -1259189619L, 
2110196018L, -1015246932L, 1805885105L, -1645832437L, 1000860821L, 
-693011612L, -843431922L, -242650762L, -558676179L, -1256790071L, 
800396782L, -1748206454L, -555738314L, -1512478199L, 1947141636L, 
1852784704L, -6829052L, -1614695797L, 1610126043L, 1677797671L
)

.Random.seed <- saved_seed

record <- simFossilRecord(
	p = 1/0.97,
	q = 1/0.97, 
	r = 1/0.97, 
	nruns = 1,
	# controls
	totalTime = c(0, 1000), 
	nTotalTaxa = c(1, 1000),
	# basically only conditioned on at least 1 extant taxon
	nExtant = c(1, 1000),
	# and 10 to 100 sampled fossil taxa
	nSamp = c(10,100),
	plot = TRUE
	)

testRes <- paleotree:::checkRecordForNoDatePastZero(fossilRecord = record)

#if(!testRes){
#	stop("checkRecordForNoDatePastZero returned FALSE")
#	}

expect_true(testRes)	

})


#####################
# second reproducible example 07-08-19

test_that("simFossilRecord doesn't produce negative dates_testB", {

library(paleotree)

saved_seed <- c(
10403L, 265L, -1894222846L, -1933042006L, -1025502830L, -109786859L, 
1221478554L, -59892047L, -360079513L, -583920750L, 338891203L, 
-1935115524L, -633688930L, 191094328L, 2116629319L, -1554692779L, 
671635032L, 1616298720L, 747909975L, -1857477573L, -1721905128L, 
-1966599810L, -458288604L, 137723694L, -440377403L, -1939425950L, 
902476805L, 790408964L, 1602659425L, -733101364L, -733228360L, 
-2027886496L, -1358793845L, 2080626873L, -100703053L, 944252198L, 
-2093956194L, -2027713484L, 1356924611L, -1187177207L, 1758828355L, 
-606655471L, -454535642L, -1506092222L, 679041013L, -763194357L, 
758560184L, 738323736L, -1765429573L, 506550337L, 303079099L, 
-1230876546L, 1295138149L, -1105885258L, 1196040161L, 1170413274L, 
404825274L, 595744542L, -847695697L, 2126907700L, 1591716239L, 
-684865548L, -1235004678L, 1413962226L, -271751711L, 165126651L, 
312405022L, 60615030L, 1229937784L, 1511672450L, 1468861446L, 
-356273965L, -1649297319L, -1694661468L, -838441302L, -917727042L, 
-1943213172L, -2103049871L, 1841950735L, -1394859159L, 457683985L, 
665090022L, 54389997L, 553275031L, -1469765379L, -469346201L, 
714383127L, -1424970434L, 1840699287L, 392437561L, -1098254593L, 
-797090633L, -1792332815L, -1174883648L, -3201984L, 1852559461L, 
1536687400L, 27854382L, 875296809L, -662035376L, 1192198965L, 
1294474558L, -1988957560L, 129449383L, 707296415L, 28007460L, 
1183649259L, -1131063328L, -269898345L, 1861479168L, 388860788L, 
1613081172L, 1138238736L, 2047005270L, -2078413210L, 2025511521L, 
325802665L, -1842967785L, -798419117L, 188042860L, -1814705692L, 
1659615618L, 1350586304L, -1313127794L, 65202480L, -1593843941L, 
-904978723L, 1979268368L, 932532199L, -337225230L, 90600732L, 
159401046L, -1032048180L, -632892775L, 13543921L, 1692578474L, 
167462303L, -246865651L, 522779771L, -996553506L, 1207589832L, 
577115772L, -2044375473L, 1312177809L, -2129010739L, -1355975463L, 
1027687810L, -1485531717L, -2100415858L, -966373007L, 999484170L, 
460509425L, 1964376047L, -1354368904L, -234395110L, -664717623L, 
2147109960L, -1968221692L, -1677520491L, 129792609L, 509654262L, 
-1421193626L, -279782963L, 15120314L, 1125644024L, 2036763253L, 
-447981457L, -1984274015L, 71298556L, -210209582L, -2036840306L, 
2007979353L, -1190316623L, -469927145L, 1629280977L, -1055303912L, 
1234415967L, -587485118L, -2089269954L, 286509772L, 946522649L, 
1211190690L, -14121361L, 258907079L, 1784863367L, 554475819L, 
-554514593L, 954398875L, 673781150L, -46512803L, 774640050L, 
1708573537L, -47339763L, -2013393611L, -999900256L, -457200712L, 
1558402571L, -1407106514L, 1300781172L, 932129338L, -941553171L, 
-1513433620L, -21062085L, 97749591L, -1379477749L, -1468077150L, 
95982036L, 1101220499L, -502586821L, 536599039L, 1095694083L, 
1249617249L, -1720443365L, -1931911438L, -981148786L, -992763006L, 
-206132561L, 1521936283L, -1652823200L, 377659524L, 724949828L, 
604415481L, -8391854L, 1964941013L, 1495347223L, -1994892809L, 
470881879L, 266007722L, -1848962333L, -2046739197L, 283942407L, 
-803563339L, -333999451L, -423200686L, -548717583L, 688050236L, 
731195532L, -1617231567L, -720570633L, 511131161L, 1041348749L, 
954389980L, 529115020L, -1616795425L, 1456634933L, 360460483L, 
-976729337L, 1867049220L, 611767495L, 802211367L, 1604830715L, 
1182753418L, 1047551516L, -977310009L, 2144258694L, 1498298911L, 
70959679L, -1369480719L, 806573501L, 403547392L, -195291095L, 
798000418L, 2127500694L, -1849129025L, -687303777L, -1525089479L, 
963593838L, -158172092L, 1635974736L, 1521007353L, -206583914L, 
-498866465L, 2055719569L, -281672779L, -776138912L, 1380004239L, 
-12670000L, 270623158L, -1582392279L, 645592001L, -228728425L, 
2063783501L, 2080273936L, -1987556896L, 882614370L, -61374210L, 
1598242818L, 980946572L, 1402164002L, -445604467L, -1105176730L, 
-1210520032L, -123915692L, 1460384097L, 937996104L, 1274901112L, 
685182864L, 216007531L, -1688580657L, 857895112L, -1952993872L, 
1499217099L, 571656876L, 1294862542L, -1722176048L, 2018374148L, 
-1862438705L, -1233699590L, 244698063L, 1924312073L, -1563187722L, 
1726716066L, 992879779L, 404965833L, -1960007297L, -1220769316L, 
-1185948758L, -1498495758L, 1881545673L, 522955932L, -865366064L, 
-2085420893L, 18127359L, 43138436L, 819795107L, -244422753L, 
-1288075706L, -886094963L, -1297126780L, -2058220377L, -396896852L, 
43446690L, -1821657650L, 1531289497L, -1591850013L, 150831800L, 
793565107L, -882259681L, 762444942L, -103445203L, -175537387L, 
-578957675L, -1351031238L, -1022589543L, 1337840319L, -541866608L, 
1989090810L, -1722102886L, 1886878736L, 1360063345L, 1593135967L, 
-467588209L, -1128453118L, -1905646124L, -1520961216L, 48609795L, 
-857700198L, 218796654L, -1318291951L, -1738945352L, 1311728022L, 
-1533322627L, -713857498L, -1171906773L, -2075985602L, -321165104L, 
1596351694L, -871365309L, -699691061L, 1151253950L, 438629155L, 
768729269L, -450249120L, 1237479622L, -1377066971L, 1590220252L, 
-1687061434L, -294506345L, -239989571L, 505223144L, 1227858691L, 
665822658L, 1514490062L, 423011487L, 944652376L, -835625330L, 
1176711580L, 253591370L, 566450670L, -1306187412L, -1543751365L, 
1786360920L, -1522666293L, -1653504171L, 339862007L, -106544923L, 
704538048L, 1444158266L, -883518127L, 1028221995L, 194136558L, 
-2042150032L, -312764949L, 196771420L, -1456144739L, -1955573569L, 
118428340L, 1275154082L, -808048955L, -323931561L, -1090021379L, 
-636591184L, -1608385336L, -927294454L, 1625003464L, -1466232606L, 
-1429286560L, -2144293145L, 864274577L, 305066253L, 534550227L, 
1411403792L, -571693490L, -1689275798L, 1080320998L, 1405114902L, 
1727996708L, -1301659212L, -607665018L, 314129719L, -602478843L, 
-773921730L, 1139980041L, 715961557L, 1830864144L, 1525967337L, 
-929643465L, -1813709190L, -929891508L, 1578676464L, -1182811762L, 
984922892L, 389629469L, 1673492755L, -462670764L, -246277774L, 
-767929486L, -802416236L, -1940884981L, 640170722L, -165993819L, 
1696892218L, 1464588922L, -1653596071L, 1210818999L, -670376827L, 
-731102808L, -777216526L, -898296394L, 1561615746L, 1831006025L, 
1111556347L, -263246572L, -1163356183L, 467276676L, 203500682L, 
359485269L, 705462960L, 927838281L, -1782081487L, -950942864L, 
976412356L, 400905896L, -733281316L, 1068664818L, 451303149L, 
-1103801678L, -1088841592L, -228673413L, -1869543477L, 866383748L, 
-409689948L, -1612116215L, -190246274L, -194509423L, 1206603931L, 
117067584L, -1613500060L, -1541486997L, -1473099121L, -475673387L, 
-1245551072L, -851373953L, -1408246220L, 1457745360L, -248399565L, 
624674363L, -923955119L, -492808034L, 616737261L, -145960398L, 
465456997L, 832542447L, -764063146L, 813069861L, -527647017L, 
1766834209L, 101117051L, -722236970L, 931218381L, -1629313845L, 
-2106158277L, -1000293403L, -182009680L, 1436681922L, -662110697L, 
1089360825L, 1998180686L, 15467122L, -2007092026L, 64293585L, 
-1862660341L, -1166834028L, 1325299447L, 1033331624L, 613513384L, 
-244292668L, 1556122232L, -1471134068L, 1782351979L, 1275930866L, 
-1944590852L, 566724409L, 371640717L, 202304414L, -1723675232L, 
648615189L, 159081694L, -793714735L, -1940374247L, 129919944L, 
-700447199L, 1229273040L, -133109680L, 447051902L, 343010603L, 
-1520726198L, 1289811180L, -1831549669L, -54375447L, 207499460L, 
-926501899L, -36679808L, -346957311L, -517667264L, 1412720009L, 
780240589L, 1698566688L, -587072300L, -1627535114L, -1776369547L, 
1352056769L, 1249221095L, 2030017608L, -189665187L, -1914942373L, 
1529193725L, -1361527196L, 2056450823L, 1548689335L, 407292182L, 
-97738409L, 1476271457L, 2049889656L, -1234310459L, 613419929L, 
1313559959L, 1843280481L, 68659415L, -2003968968L, 298833804L, 
-967490466L, 1587269028L, -1406278687L, -907344964L, -1369424299L, 
1374519002L, -1170529598L, -1020031440L, -841821598L, 892971175L, 
582131352L, -856201933L, -1923603158L, -554907061L, 528470058L, 
-520620721L, 1858375074L, 1260200833L, 884420306L, 170422965L, 
-1091509229L, 1341083156L, 614714942L, 713550238L, -262468024L, 
-998188749L, 1217726001L, 2055208521L, 1173791159L, 192457121L, 
389959635L, 1032159058L, 73799583L, -1353392281L, -324182679L, 
1627248569L, -1412578450L, -778744804L, 1750339766L, -1851563057L, 
2012418753L, -1369889007L, -891159728L, -557149156L, -1931825328L
)

.Random.seed <- saved_seed

record <- simFossilRecord(
	p = 1/0.97,
	q = 1/0.97, 
	r = 1/0.97, 
	nruns = 1,
	# controls
	totalTime = c(0, 1000), 
	nTotalTaxa = c(1, 1000),
	# basically only conditioned on at least 1 extant taxon
	nExtant = c(1, 1000),
	# and 10 to 100 sampled fossil taxa
	nSamp = c(10,100),
	plot = TRUE
	)

testRes <- paleotree:::checkRecordForNoDatePastZero(fossilRecord = record)

#if(!testRes){
#	stop("checkRecordForNoDatePastZero returned FALSE")
#	}

expect_true(testRes)

})

