% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_specimens}
\alias{pbdb_specimens}
\title{Get information about multiple fossil specimens}
\usage{
pbdb_specimens(...)
}
\arguments{
\item{...}{Arguments passed to the API.  See all available
arguments at \url{https://paleobiodb.org/data1.2/specs/list}. See the
\code{\link[=pbdb_occurrences]{pbdb_occurrences()}} documentation for an explanation about the
main filtering parameters.}
}
\value{
A data frame with the fossil specimens that match the
query.
}
\description{
Returns information about multiple fossil specimens, selected
according to the parameters you provide.  Depending upon which
output blocks you select (\code{show} parameter), the response will
contain some fields describing the specimens and some describing
the occurrences and collections (if any) with which they are
associated.
}
\examples{
\dontrun{
  pbdb_specimens(base_name = "Cetacea", interval = "Miocene", vocab = "pbdb")
}
}
