% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidden.R
\name{other}
\alias{other}
\alias{.prepare}
\alias{.simulate}
\alias{.predict}
\alias{.select}
\title{Other functions (manuscript)}
\usage{
.prepare(X, filter = 1, cutoff = "zero", scale = TRUE)

.simulate(x, effects)

.predict(y, X, nfolds.ext = 5, nfolds.int = 5, standard = TRUE,
  family = "binomial", ...)

.select(y, X, index, nfolds = 5, standard = TRUE, adaptive = TRUE, ...)
}
\arguments{
\item{X}{covariates\strong{:}
matrix with \eqn{n} rows and \eqn{p} columns}

\item{filter}{numeric, multiplying the sample size}

\item{cutoff}{character "zero", "knee", or "half"}

\item{scale}{logical}

\item{x}{covariates\strong{:}
list of length \eqn{k},
including matrices with \eqn{n} rows and \eqn{p} columns}

\item{effects}{number of causal covariates\strong{:}
vector of length \eqn{k}}

\item{y}{response\strong{:}
vector of length \eqn{n}}

\item{nfolds.ext}{number of external folds}

\item{...}{arguments for \link[palasso]{palasso}}

\item{index}{indices of causal covariates\strong{:}
list of length \eqn{k},
including vectors}

\item{trial}{development option}
}
\value{
to do
}
\description{
Functions for the \code{palasso} manuscript.
}
\details{
The function \code{.prepare} pre-processes sequencing data. It removes
features with a low total abundance, adjusts for different library sizes,
binarises the counts with cutoff zero or takes the Anscombe transform, and
scales all covariates to mean zero and unit variance.
(If the cutoff differed from zero, we would have to first normalise,
then binarise, and finally filter the raw counts.)

The function \code{.simulate} simulates a response. Exploiting an
experimental covariate matrix, it allows for different numbers of non-zero
coefficients for X and Z.

The function \code{.predict} estimates the predictive performance of
different lasso models (standard X and/or Z, adaptive X and/or Z, paired
X and Z). Minimising the deviance, it returns the deviance and the area
under the curve. Currently, only the binomial family is implemented.

The function \code{.select} estimates the selective performance of different
lasso models (standard X and/or Z, adaptive X and/or Z, paired X and Z).
Limiting the number of covariates to \eqn{10}, it returns the number of
selected covariates, and the number of correctly selected covariates.
}
\examples{
\donttest{set.seed(1)
n <- 30; p <- 40
X <- matrix(rpois(n*p,lambda=3),nrow=n,ncol=p)
x <- palasso:::.prepare(X)
y <- palasso:::.simulate(x,effects=c(1,2))
predict <- palasso:::.predict(y,x)
select <- palasso:::.select(y,x,attributes(y))}



}
\seealso{
Use \link[palasso]{palasso} to fit the paired lasso.
}
\keyword{internal}
