% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax_range_strat.R
\name{tax_range_strat}
\alias{tax_range_strat}
\title{Generate a stratigraphic section plot}
\usage{
tax_range_strat(
  occdf,
  name = "genus",
  level = "bed",
  certainty = NULL,
  by = "FAD",
  plot_args = NULL,
  x_args = NULL,
  y_args = NULL
)
}
\arguments{
\item{occdf}{\code{dataframe}. A dataframe of fossil occurrences containing
at least two columns: names of taxa, and their stratigraphic position (see
\code{name} and \code{level} arguments).}

\item{name}{\code{character}. The name of the column you wish to be treated
as the input names, e.g. "genus" (default).}

\item{level}{\code{character}. The name of the column you wish to be treated
as the stratigraphic levels associated with each occurrence, e.g. "bed"
(default) or "height". Stratigraphic levels must be \code{numeric}.}

\item{certainty}{\code{character}. The name of the column you wish to be
treated as the information on whether an identification is certain (1) or
uncertain (0). By default (\code{certainty = NULL}), no column name is
provided, and all occurrences are assumed to be certain. In the plot,
certain occurrences will be plotted with a black circle and joined with
solid lines, while uncertain occurrences will be plotted with a white
circle and joined with dashed lines.}

\item{by}{\code{character}. How should the output be sorted? Either: "FAD"
(first appearance; default), "LAD" (last appearance), or "name"
(alphabetically by taxon names).}

\item{plot_args}{A list of optional arguments that are passed directly to
\code{\link[graphics:plot.default]{graphics::plot()}}. Subsets of these arguments are also passed to
\code{\link[graphics:segments]{graphics::segments()}} and \code{\link[graphics:points]{graphics::points()}} (see Details). Useful
arguments include \code{xlab} (the x-axis label), \code{ylab} (the y-axis label,
default is "Bed number"), \code{main} (the plot title), \code{xlim} (the x-axis
limits), and \code{ylim} (the y-axis limits). The \code{axes} and \code{type} arguments
are not supported and will be overridden.}

\item{x_args}{A list of optional arguments that are passed directly to
\code{\link[=axis]{axis()}} when generating the x-axis. Useful arguments include \code{font} (e.g.,
\code{3} is italic) and \code{las} (label orientation). The \code{side} argument is not
supported and will be overridden. If the \code{at} and \code{labels} arguments are
not specified, the x-axis tick labels will be set to the taxon names.}

\item{y_args}{A list of optional arguments that are passed directly to
\code{\link[=axis]{axis()}} when generating the y-axis. Useful arguments include \code{font} (e.g.,
\code{3} is italic) and \code{las} (label orientation). The \code{side} argument is not
supported and will be overridden. If the \code{at} argument is not specified, it
will be set to a vector of the unique values from the \code{level} column.}
}
\value{
Invisibly returns a data.frame of the calculated taxonomic
stratigraphic ranges.

The function is usually used for its side effect, which is to create a plot
showing the stratigraphic ranges of taxa in a section, with levels at which
the taxon was sampled indicated with a point.
}
\description{
A function to plot the stratigraphic ranges of fossil taxa from occurrence
data.
}
\details{
Note that the default spacing for the x-axis title may cause it to
overlap with the x-axis tick labels. To avoid this, you can call
\code{\link[graphics:title]{graphics::title()}} after running \code{tax_range_strat()} and specify both
\code{xlab} and \code{line} to add the x-axis title farther from the axis (see
examples).

The styling of the points and line segments can be adjusted by supplying
named arguments to \code{plot_args}. \code{col} (segment and point color), \code{lwd}
(segment width), \code{pch} (point symbol), \code{bg} (background point color for
some values of \code{pch}), \code{lty} (segment line type), and \code{cex} (point size)
are supported. In the case of a column being supplied to the \code{certainty}
argument, these arguments may be vectors of length two, in which case the
first value of the vector will be used for the "certain" points and
segments, and the second value of the vector will be used for the
"uncertain" points and segments. If only a single value is supplied, it
will be used for both. The default values for these arguments are as
follows:
\itemize{
\item \code{col} = \code{c("black", "black")}
\item \code{lwd} = \code{c(1.5, 1.5)}
\item \code{pch} = \code{c(19, 21)}
\item \code{bg} = \code{c("black", "white")}
\item \code{lty} = \code{c(1, 2)}
\item \code{cex} = \code{c(1, 1)}
}
}
\section{Developer(s)}{
 Bethany Allen, William Gearty & Alexander Dunhill
}

\section{Reviewer(s)}{
 William Gearty & Lewis A. Jones
}

\examples{
# Load tetrapod dataset
data(tetrapods)
# Sample tetrapod occurrences
tetrapod_names <- tetrapods$accepted_name[1:50]
# Simulate bed numbers
beds_sampled <- sample.int(n = 10, size = 50, replace = TRUE)
# Simulate certainty values
certainty_sampled <- sample(x = 0:1, size = 50, replace = TRUE)
# Combine into data frame
occdf <- data.frame(taxon = tetrapod_names,
                    bed = beds_sampled,
                    certainty = certainty_sampled)
# Plot stratigraphic ranges
par(mar = c(12, 5, 2, 2))
tax_range_strat(occdf, name = "taxon")
tax_range_strat(occdf, name = "taxon", certainty = "certainty",
                plot_args = list(ylab = "Stratigraphic height (m)"))
# Plot stratigraphic ranges with more labelling
tax_range_strat(occdf, name = "taxon", certainty = "certainty", by = "name",
                plot_args = list(main = "Section A",
                                 ylab = "Stratigraphic height (m)"))
eras_custom <- data.frame(name = c("Mesozoic", "Cenozoic"),
                          max_age = c(0.5, 3.5),
                          min_age = c(3.5, 10.5),
                          color = c("#67C5CA", "#F2F91D"))
axis_geo(side = 4, intervals = eras_custom, tick_labels = FALSE)
title(xlab = "Taxon", line = 10.5)

}
