% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lockfile-metadata.R
\name{lockfile-metadata}
\alias{lockfile-metadata}
\alias{set_lockfile_metadata}
\alias{lockfile-metadata}
\alias{get_lockfile_metadata}
\title{Get / Set packrat lockfile metadata}
\usage{
set_lockfile_metadata(repos = NULL, r_version = NULL, project = NULL)

get_lockfile_metadata(metadata = NULL, simplify = TRUE, project = NULL)
}
\arguments{
\item{repos}{A named character vector of the form \code{c(<repoName> = "<pathToRepo>")}.}

\item{r_version}{A length-one character vector with suitable numeric version
string. See \code{\link[base]{package_version}}.}

\item{project}{The project directory. When in packrat mode, defaults to the current project;
otherwise, defaults to the current working directory.}

\item{metadata}{The lockfile field name(s) to draw from.}

\item{simplify}{Boolean; if \code{TRUE} the returned metadata will be un-listed.}
}
\description{
Get and set metadata in the current packrat-managed project lockfile \code{packrat.lock}
}
\details{
Project's \code{packrat.lock} contains some metadata before packages
dependencies informations. The project's lockfile is created and updated
programmatically by \code{\link{snapshot}}. However it could be necessary sometimes to
modify manually some of those values. For example, it could be useful to set another repository
CRAN url when deploying to a offline environnement.
}
\section{available metadata }{


\itemize{
\item \code{r_version}: R version the project depends on
\item \code{repos}: Name of repos and their url recorded packages can be
retrieve from. Only url is recommended to change if need. Name of repos is
used in package records and must be identical
}
}

\examples{
\dontrun{
# changes repos url
repos <- old_repos <- get_lockfile_metadata("repos")
repos
repos["CRAN"] <- "https://cran.r-project.org/"
set_lockfile_metadata(repos = repos)
get_lockfile_metadata("repos")
# setting back old state
# set_lockfile_metadata(repos = old_repos)

# changes R version
rver <- old_rver <- get_lockfile_metadata("r_version")
rver
rver <- "3.4.1"
set_lockfile_metadata(r_version = rver)
get_lockfile_metadata("r_version")
# Setting back old state
# set_lockfile_metadata(r_version = old_rver)
}
}
