% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/package_downloads.R
\name{package_downloads}
\alias{package_downloads}
\title{Track package downloads from Rstudio's CRAN mirror}
\usage{
package_downloads(package_name, start = as.Date("2012-10-01"),
  end = Sys.Date() - 1,
  cache_dir = package_download_cache_dir(package_name), force = FALSE)
}
\arguments{
\item{package_name}{Name of the package to get download statistics for}

\item{start}{first day of requested download stats}

\item{end}{last day of requested download stats}

\item{cache_dir}{cache folder to use, defaults to one given by rappdirs}

\item{force}{if TRUE, user is not prompted to confirm writing to hard
disk (intended for non-interactive use)
\code{\link{package_download_cache_dir}} (via rappdirs)}
}
\description{
Results are cached in a local folder.
}
\examples{
\dontrun{package_download("package_downloads", start = as.Date("2015-09-01"))}
}

