% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3c_cost_analysis_functions.R
\name{microcosting_liquids}
\alias{microcosting_liquids}
\title{Function to estimate the cost of liquids taken (from IPD)}
\usage{
microcosting_liquids(
  ind_part_data,
  name_med,
  dose_med,
  dose_unit,
  bottle_size,
  bottle_remain,
  bottle_size_unit = NULL,
  unit_cost_data,
  unit_cost_column,
  cost_calculated_in,
  strength_column,
  list_period_timepoint,
  preparation = NULL,
  list_of_code_names = NULL,
  list_of_code_dose_unit = NULL,
  list_of_code_bottle_size = NULL,
  equiv_dose = NULL,
  basis_time = "day"
)
}
\arguments{
\item{ind_part_data}{IPD}

\item{name_med}{name of medication}

\item{dose_med}{dose of medication}

\item{dose_unit}{unit of strength}

\item{bottle_size}{how many taken}

\item{bottle_remain}{frequency of medication}

\item{bottle_size_unit}{unit which size of the bottle is expressed}

\item{unit_cost_data}{unit costs data
assumes unit cost data contains the columns, name of medication,
form/type, strength,
unit of strength, preparation, unitcost, size and size unit
(in which except name and form are to be passed in)}

\item{unit_cost_column}{column name of unit cost in unit_cost_data}

\item{cost_calculated_in}{column name of unit where the cost is calculated}

\item{strength_column}{column name of strength in the unit cost data}

\item{list_period_timepoint}{list of time period at each timepoint}

\item{preparation}{preparation of liquid that is used}

\item{list_of_code_names}{if names is coded, give the code:name pairs}

\item{list_of_code_dose_unit}{if unit is coded, give the code:unit pairs}

\item{list_of_code_bottle_size}{list of codes for the bottle sizes fi used}

\item{equiv_dose}{if cost per equivalent doses are to be calculates,
provide equiv_dose}

\item{basis_time}{time needed to convert , default is day}
}
\value{
the calculated cost of liquids along with original data
}
\description{
Function to estimate the cost of liquids taken (from IPD)
}
\examples{
med_costs_file <- system.file("extdata", "average_unit_costs_med.csv",
package = "packDAMipd")
data_file <- system.file("extdata", "resource_use_l.csv",
package = "packDAMipd")
ind_part_data <- load_trial_data(data_file)
med_costs <- load_trial_data(med_costs_file)
res <- microcosting_liquids(
  ind_part_data, "Drug", "liq_dosage", "liquid_dose_unit",
  "liquid_bottle_size", "liquid_bottle_remain_time", NULL,
  med_costs, "UnitCost", "SizeUnit", "Strength", NULL, NULL, NULL,
  NULL, NULL, "liquid_equiv_dose", "day"
)
}
