% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pRep1.R
\name{pRep1}
\alias{pRep1}
\title{First series of p-rep designs}
\usage{
pRep1(v, m, s)
}
\arguments{
\item{v}{Total number of treatments or breeding lines or entries}

\item{m}{positive integer (>=1)}

\item{s}{positive integer (>=3)}
}
\value{
This function generates p-rep designs with parameters:

v = 2ms(s-1) : number of treatments,

b_1 = 2(s-1) : first set of blocks of size k_1 = ms,

b_2 = 2s : second set of blocks of size k_2 = 2m(s-1) and

r = 3 : number of replications.

e = 2 : number of environments,

This function also generates incidence matrix, information matrix, canonical efficiency factor and average variance factor of the generated p-rep design.
}
\description{
This function generates first series of p-rep designs for given values of v, m and s. The input should satisfy the condition v=2*m*s*(s-1), m>=1 and s>=3.
}
\examples{
library(pRepDesigns)
pRep1(24, 2, 3)

}
\references{
Williams E, Piepho HP, Whitaker D (2011)<https://doi.org/10.1002/bimj.201000102>
}
