% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ozmap.R
\name{ozmap_data}
\alias{ozmap_data}
\title{Australia map data}
\usage{
ozmap_data(data = "states", quiet = FALSE, ...)
}
\arguments{
\item{data}{name of layer to return, see details}

\item{quiet}{set to \code{TRUE} to suppress messages}

\item{...}{unused}
}
\value{
\code{sf} data frame with 'NAME' and 'geometry' columns
}
\description{
Return simple features data frames of various Australian map layers.
}
\details{
Available layers are
\itemize{
\item \strong{states} \link{ozmap_states} state and territories (low resolution)
\item \strong{country} \link{ozmap_country} entire country (low resolution)
\item \strong{abs_ced} \link{abs_ced} country level electoral divisions
\item \strong{abs_lga} \link{abs_lga} local government areas
\item \strong{abs_ste} \link{abs_ste} state and territories
}
}
\examples{

country_sf <- ozmap_data("country")

\donttest{
 ## can take time to print out
  (lga_sf <- ozmap_data("abs_lga"))
}
}
