% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WFSClient.R
\docType{class}
\name{WFSClient}
\alias{WFSClient}
\title{WFSClient}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Web Feature Service.
}
\description{
WFSClient
}
\section{Methods}{

\describe{
 \item{\code{new(url, serviceVersion, user, pwd, logger)}}{
   This method is used to instantiate a WFSClient with the \code{url} of the
   OGC service. Authentication is supported using basic auth (using \code{user}/\code{pwd} arguments), 
   bearer token (using \code{token} argument), or custom (using \code{headers} argument). By default, the \code{logger}
   argument will be set to \code{NULL} (no logger). This argument accepts two possible 
   values: \code{INFO}: to print only \pkg{ows4R} logs, \code{DEBUG}: to print more verbose logs
 }
 \item{\code{getCapabilities()}}{
   Get service capabilities. Inherited from OWS Client
 }
 \item{\code{reloadCapabilities()}}{
   Reload service capabilities
 }
 \item{\code{describeFeatureType(typeName)}}{
   Get the description of a given featureType
 }
 \item{\code{getFeatures(typeName, ...)}}{
   Retrieves the features for a given feature type.
 }
 \item{\code{getFeatureTypes(pretty)}}{
   List the feature types available. If \code{pretty} is TRUE,
   the output will be an object of class \code{data.frame}
 }
}
}

\examples{
\donttest{
   #example based on a WFS endpoint responding at http://localhost:8080/geoserver/wfs
   wfs <- WFSClient$new("http://localhost:8080/geoserver/wfs", serviceVersion = "1.1.1")
   
   #get capabilities
   caps <- wfs$getCapabilities()
   
   #find feature type
   ft <- caps$findFeatureTypeByName("mylayer")
   if(length(ft)>0){
     data <- ft$getFeatures()
     data_with_filter <- ft$getFeatures(cql_filter = "somefilter")
   }
   
   #Advanced examples at https://github.com/eblondel/ows4R/wiki#wfs
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Feature}
\keyword{OGC}
\keyword{WFS}
