% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_overture.R
\name{as_overture}
\alias{as_overture}
\title{Convert a tbl_sql object to a overture_call object}
\usage{
as_overture(x, type, theme = get_theme_from_type(type))
}
\arguments{
\item{x}{A tbl_sql object representing an Overture Maps dataset.}

\item{type}{A string specifying the type of overture dataset to read.
Setting to "*" or \code{NULL} will read all types for a given theme.}

\item{theme}{Inferred from type by default. Must be set if type is "*" or NULL}
}
\value{
A tbl_sql object with the additional class overture_call and
attributes overture_type and overture_theme.
}
\description{
This function adds the overture_call class to a tbl_sql object.  It is
primarily used internally#' by the open_curtain() function but can also be
used directly on tbl_sql #' objects representing Overture Maps data.
}
\details{
The function adds the overture_call class as the first class of the object
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# The open_curtain() function already uses as_overture() internally,
# but you can also use it directly:
conn <- stage_conn()
division <- open_curtain("division", tablename = "test")

class(division)

# views
division2 <- tbl(conn, "test")
division2 <- as_overture(division2)

exit_stage(conn)
\dontshow{\}) # examplesIf}
}
