% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{histogram_record}
\alias{histogram_record}
\title{Record a value of an OpenTelemetry histogram}
\usage{
histogram_record(name, value, attributes = NULL, context = NULL, meter = NULL)
}
\arguments{
\item{name}{Name of the histogram.}

\item{value}{Value to record.}

\item{attributes}{Additional attributes to add.}

\item{context}{Span context. If missing the active context is used,
if any.}

\item{meter}{Meter object (\link{otel_meter}). Otherwise it is passed to
\code{\link[=get_meter]{get_meter()}} to get a meter.}
}
\value{
The histogram object (\link{otel_histogram}), invisibly.
}
\description{
Record a value of an OpenTelemetry histogram
}
\examples{
otel::histogram_record("response-time", 0.2)
}
\seealso{
Other OpenTelemetry metrics instruments: 
\code{\link{counter_add}()},
\code{\link{gauge_record}()},
\code{\link{up_down_counter_add}()}

Other OpenTelemetry metrics API: 
\code{\link{counter_add}()},
\code{\link{gauge_record}()},
\code{\link{is_measuring_enabled}()},
\code{\link{up_down_counter_add}()}
}
\concept{OpenTelemetry metrics API}
\concept{OpenTelemetry metrics instruments}
