/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.util.GridMap;
import fr.ird.osmose.util.SimulationLinker;
import java.io.IOException;
import java.util.ArrayList;

public class MapSet
extends SimulationLinker {
    private final String prefix;
    private final int iSpecies;
    private int[][] indexMaps;
    private GridMap[] maps;
    private String[] mapFile;

    public MapSet(int rank, int iSpecies, String prefix) {
        super(rank);
        this.iSpecies = iSpecies;
        this.prefix = prefix;
    }

    public void init() {
        this.loadMaps();
        if (!this.checkMapIndexation()) {
            this.getSimulation().error("Missing map indexation for species " + this.getSpecies(this.iSpecies).getName() + " in map series '" + this.prefix + ".map*'. Please refer to prior warning messages for details.", null);
        }
        this.eliminateTwinMap();
    }

    public int getNMap() {
        return this.maps.length;
    }

    public GridMap getMap(int numMap) {
        return this.maps[numMap];
    }

    public GridMap getMap(School school) {
        return this.getMap(this.getIndexMap(school));
    }

    public String getMapFile(int numMap) {
        return this.mapFile[numMap];
    }

    public int getIndexMap(int iAge, int iStep) {
        return this.indexMaps[iAge][iStep];
    }

    public int getIndexMap(School school) {
        return this.getIndexMap(school.getAgeDt(), this.getSimulation().getIndexTimeSimu());
    }

    public void loadMaps() {
        int nmapmax = this.getConfiguration().findKeys(this.prefix + ".map*.species").size();
        ArrayList<Integer> mapNumber = new ArrayList<Integer>();
        int imap = 0;
        for (int n = 0; n < nmapmax; ++n) {
            while (!this.getConfiguration().canFind(this.prefix + ".map" + imap + ".species")) {
                ++imap;
            }
            String key = this.prefix + ".map" + imap + ".species";
            Species species = this.getSpecies(this.getConfiguration().getString(key));
            if (null != species) {
                if (species.getIndex() == this.iSpecies) {
                    mapNumber.add(imap);
                }
            } else {
                this.error("Wrong species name in spatial map series '" + this.prefix + ".map*'", new IOException("Parameter " + key + " = " + this.getConfiguration().getString(key) + " does not match any predefined species name."));
            }
            ++imap;
        }
        this.maps = new GridMap[mapNumber.size()];
        this.mapFile = new String[mapNumber.size()];
        int nSteps = this.getConfiguration().getNStepYear() * this.getConfiguration().getNYear();
        int lifespan = this.getSpecies(this.iSpecies).getLifespanDt();
        this.indexMaps = new int[lifespan][];
        for (int iAge = 0; iAge < lifespan; ++iAge) {
            this.indexMaps[iAge] = new int[nSteps];
            for (int iStep = 0; iStep < nSteps; ++iStep) {
                this.indexMaps[iAge][iStep] = -1;
            }
        }
        for (int n = 0; n < mapNumber.size(); ++n) {
            String csvFile;
            imap = (Integer)mapNumber.get(n);
            int ageMin = Math.round(this.getConfiguration().getFloat(this.prefix + ".map" + imap + ".age.min") * (float)this.getConfiguration().getNStepYear());
            int ageMax = Math.round(this.getConfiguration().getFloat(this.prefix + ".map" + imap + ".age.max") * (float)this.getConfiguration().getNStepYear());
            ageMax = Math.min(ageMax, this.getSpecies(this.iSpecies).getLifespanDt());
            int[] mapSeason = this.getConfiguration().getArrayInt(this.prefix + ".map" + imap + ".season");
            int yearMin = 0;
            int yearMax = this.getConfiguration().getNYear();
            if (!this.getConfiguration().isNull(this.prefix + ".map" + imap + ".year.min")) {
                yearMin = this.getConfiguration().getInt(this.prefix + ".map" + imap + ".year.min");
                yearMin = Math.max(yearMin, 0);
            }
            if (!this.getConfiguration().isNull(this.prefix + ".map" + imap + ".year.max")) {
                yearMax = this.getConfiguration().getInt(this.prefix + ".map" + imap + ".year.max");
                yearMax = Math.min(yearMax, this.getConfiguration().getNYear());
            }
            int nStepYear = this.getConfiguration().getNStepYear();
            for (int iAge = ageMin; iAge < ageMax; ++iAge) {
                for (int iYear = yearMin; iYear < yearMax; ++iYear) {
                    for (int iStep : mapSeason) {
                        this.indexMaps[iAge][iYear * nStepYear + iStep] = n;
                    }
                }
            }
            if (!this.getConfiguration().canFind(this.prefix + ".map" + imap + ".file")) continue;
            this.mapFile[n] = csvFile = this.getConfiguration().getFile(this.prefix + ".map" + imap + ".file");
            this.maps[n] = null != csvFile ? new GridMap(csvFile) : null;
        }
    }

    private boolean checkMapIndexation() {
        boolean isMapOK = true;
        int nSteps = this.getConfiguration().getNStepYear() * this.getConfiguration().getNYear();
        int nStepYear = this.getConfiguration().getNStepYear();
        int lifespan = this.getSpecies(this.iSpecies).getLifespanDt();
        for (int iAge = 0; iAge < lifespan; ++iAge) {
            for (int iStep = 0; iStep < nSteps; ++iStep) {
                if (this.indexMaps[iAge][iStep] >= 0) continue;
                isMapOK = false;
                float age = (float)iAge / (float)nStepYear;
                int year = iStep / nStepYear;
                int step = iStep % nStepYear;
                this.getSimulation().warning("No map assigned for {0} age {1} year {2} step {3}", new Object[]{this.getSpecies(this.iSpecies).getName(), Float.valueOf(age), year, step});
            }
        }
        return isMapOK;
    }

    private void eliminateTwinMap() {
        int[] mapIndexNoTwin = new int[this.mapFile.length];
        block0: for (int k = 0; k < this.mapFile.length; ++k) {
            String file = this.mapFile[k];
            mapIndexNoTwin[k] = k;
            if (null == file) continue;
            for (int l = k - 1; l >= 0; --l) {
                if (!file.equals(this.mapFile[l])) continue;
                mapIndexNoTwin[k] = mapIndexNoTwin[l];
                this.maps[k] = null;
                continue block0;
            }
        }
        for (int iAge = 0; iAge < this.indexMaps.length; ++iAge) {
            for (int iStep = 0; iStep < this.indexMaps[iAge].length; ++iStep) {
                int indexMap = this.indexMaps[iAge][iStep];
                this.indexMaps[iAge][iStep] = mapIndexNoTwin[indexMap];
            }
        }
    }
}

