/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.Prey;
import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.output.AbstractDistribOutput;
import fr.ird.osmose.output.distribution.AbstractDistribution;
import java.io.File;

public class PredatorPressureDistribOutput
extends AbstractDistribOutput {
    private final Species species;

    public PredatorPressureDistribOutput(int rank, Species species, AbstractDistribution distrib) {
        super(rank, distrib);
        this.species = species;
        this.getSimulation().requestPreyRecord();
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder("Trophic");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_predatorPressureDistribBy");
        filename.append(this.getType().toString());
        filename.append("-");
        filename.append(this.species.getName());
        filename.append("_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        StringBuilder description = new StringBuilder();
        description.append("Distribution of the preyed biomass (tonne) of ");
        description.append(this.species.getName());
        description.append(" among the predator species (in column) by ");
        description.append(this.getType().getDescription());
        description.append(". For class i, the % of preyed biomass in [i,i+1[ is reported.");
        return description.toString();
    }

    @Override
    public void update() {
        for (School predator : this.getSchoolSet().getAliveSchools()) {
            for (Prey prey : predator.getPreys()) {
                int classPrey;
                if (prey.getSpeciesIndex() != this.species.getIndex() || (classPrey = this.getClass(prey)) < 0) continue;
                double[] dArray = this.values[predator.getSpeciesIndex()];
                int n = classPrey;
                dArray[n] = dArray[n] + prey.getBiomass();
            }
        }
    }

    @Override
    public void initStep() {
    }
}

