/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose;

import fr.ird.osmose.grid.IGrid;
import fr.ird.osmose.util.Properties;
import fr.ird.osmose.util.Separator;
import fr.ird.osmose.util.logging.OLogger;
import fr.ird.osmose.util.version.VersionManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Configuration
extends OLogger {
    private final Properties cfg;
    private final Properties source;
    private final List<Parameter> parameters;
    private final String mainFilename;
    private Separator defaultSeparator;
    private String outputPathname;
    private String outputSeparator;
    private final String inputPathname;
    private int nCpu;
    private int nSpecies;
    private int nPlankton;
    private int nSimulation;
    private int nYear;
    private int nStepYear;
    private int[] nSchool;
    private IGrid grid;

    Configuration(String mainFilename, String outputPathname) {
        this.mainFilename = mainFilename;
        this.inputPathname = new File(mainFilename).getParentFile().getAbsolutePath();
        this.outputPathname = outputPathname;
        this.cfg = new Properties();
        this.source = new Properties();
        this.parameters = new ArrayList<Parameter>();
    }

    public void init() {
        this.loadParameters(this.mainFilename, 0);
        this.defaultSeparator = this.guessDefaultSeparator();
        this.parameters.clear();
        VersionManager.getInstance().updateConfiguration();
        if (null == this.outputPathname) {
            this.outputPathname = this.resolvePath(this.getString("output.dir.path"));
        }
        Separator separator = Separator.COMA;
        if (!this.isNull("output.csv.separator")) {
            try {
                separator = Separator.valueOf(this.getString("output.csv.separator").toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                this.warning("Failed to parse parameter output.csv.separator = " + this.getString("output.csv.separator") + ". It must be either " + Separator.asList());
                separator = Separator.COMA;
            }
        }
        this.outputSeparator = separator.toString();
        this.info("Output CSV separator set to " + separator.name());
        if (!this.isNull("simulation.ncpu")) {
            this.nCpu = this.getInt("simulation.ncpu");
            this.nCpu = Math.max(this.nCpu, 1);
        } else {
            this.nCpu = Integer.MAX_VALUE;
        }
        this.nSpecies = this.getInt("simulation.nspecies");
        this.nPlankton = this.getInt("simulation.nplankton");
        this.nSimulation = this.getInt("simulation.nsimulation");
        this.nCpu = Math.min(this.nCpu, this.nSimulation);
        this.nYear = this.getInt("simulation.time.nyear");
        this.nStepYear = this.getInt("simulation.time.ndtperyear");
        this.nSchool = new int[this.nSpecies];
        if (this.findKeys("simulation.nschool.sp*").size() == this.nSpecies) {
            for (int i = 0; i < this.nSpecies; ++i) {
                this.nSchool[i] = this.getInt("simulation.nschool.sp" + i);
            }
        } else if (this.canFind("simulation.nschool")) {
            int n = this.getInt("simulation.nschool");
            for (int i = 0; i < this.nSpecies; ++i) {
                this.nSchool[i] = n;
            }
        } else {
            for (int i = 0; i < this.nSpecies; ++i) {
                this.nSchool[i] = 10;
            }
        }
        this.initGrid();
    }

    public void initGrid() {
        String gridClassName = this.getString("grid.java.classname");
        try {
            this.info("Grid: " + gridClassName);
            this.grid = (IGrid)Class.forName(gridClassName).newInstance();
        }
        catch (InstantiationException ex) {
            this.error("Failed to create new grid instance. " + ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            this.error("Failed to create new grid instance. " + ex.getMessage(), ex);
        }
        catch (ClassNotFoundException ex) {
            this.error("Failed to create new grid instance. " + ex.getMessage(), ex);
        }
        this.grid.init();
    }

    private void loadParameters(String filename, int depth) {
        BufferedReader bfIn = null;
        String path = this.resolveFile(filename);
        try {
            bfIn = new BufferedReader(new FileReader(path));
        }
        catch (FileNotFoundException ex) {
            this.error("Could not fing Osmose configuration file: " + path, ex);
        }
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            msg.append("  ");
        }
        msg.append("Loading parameters from file ");
        msg.append(path);
        this.info(msg.toString());
        String line = null;
        int iline = 1;
        try {
            while ((line = bfIn.readLine()) != null) {
                Parameter entry;
                if (!this.startsWithSymbol(line = line.trim()) & line.length() > 1 && null != (entry = new Parameter(line, iline, path)).key && null != entry.value) {
                    this.parameters.add(entry);
                    if (entry.key.startsWith("osmose.configuration")) {
                        this.source.setProperty(entry.key, path);
                        this.loadParameters(entry.value, depth + 1);
                    } else if (this.source.containsKey(entry.key)) {
                        this.warning("Parameter {0} has already been defined in file {1} with value {2}", new Object[]{entry.key, this.source.getProperty(entry.key), this.cfg.getProperty(entry.key)});
                        this.warning("Osmose will ignore parameter {0} in file {1} with value {2}", new Object[]{entry.key, path, entry.value});
                    } else {
                        this.cfg.setProperty(entry.key, entry.value);
                        this.source.setProperty(entry.key, path);
                    }
                }
                ++iline;
            }
        }
        catch (IOException ex) {
            this.error("Error loading parameters from file " + filename + " at line " + iline + " " + line, ex);
        }
    }

    public void refresh() {
        this.info("Reloading parameters...");
        this.parameters.clear();
        this.cfg.clear();
        this.source.clear();
        this.loadParameters(this.mainFilename, 0);
    }

    private boolean startsWithSymbol(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        Pattern p = Pattern.compile("(^\\p{Punct})");
        Matcher m = p.matcher(value);
        return m.find();
    }

    public boolean isNull(String key) {
        try {
            return null == this.getString(key);
        }
        catch (Exception ex) {
            return true;
        }
    }

    public boolean canFind(String key) {
        try {
            this.getString(key);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public List<String> findKeys(String filter) {
        return this.cfg.getKeys(filter);
    }

    public final String getString(String key) {
        String lkey = key.toLowerCase();
        if (this.cfg.containsKey(lkey)) {
            String value = this.cfg.getProperty(lkey);
            if (value.equalsIgnoreCase("null")) {
                return null;
            }
            return value.trim();
        }
        throw new NullPointerException("Could not find parameter " + key);
    }

    public final String getSource(String key) {
        String lkey = key.toLowerCase();
        if (this.source.containsKey(lkey)) {
            return this.source.getProperty(lkey).trim();
        }
        return "null";
    }

    public String getFile(String key) {
        return this.resolveFile(this.getString(key));
    }

    public String[] getArrayString(String key) {
        String value = this.getString(key);
        String[] values = value.split(Separator.guess(value, Separator.SEMICOLON).toString());
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public int getInt(String key) {
        String s = this.getString(key);
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException ex) {
            this.error("Could not convert parameter " + key + " to integer " + s + " (from file " + this.getSource(key) + ")", ex);
            return Integer.MIN_VALUE;
        }
    }

    public float getFloat(String key) {
        String s = this.getString(key);
        try {
            return Float.valueOf(s).floatValue();
        }
        catch (NumberFormatException ex) {
            this.error("Could not convert parameter " + key + " to float " + s + " (from file " + this.getSource(key) + ")", ex);
            return Float.NaN;
        }
    }

    public double getDouble(String key) {
        String s = this.getString(key);
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException ex) {
            this.error("Could not convert parameter " + key + " to double " + s + " (from file " + this.getSource(key) + ")", ex);
            return Double.NaN;
        }
    }

    public boolean getBoolean(String key, boolean warning) {
        block4: {
            try {
                String s = this.getString(key);
                try {
                    return Boolean.valueOf(s);
                }
                catch (NumberFormatException ex) {
                    this.error("Could not convert parameter " + key + " to boolean " + s + " (from file " + this.getSource(key) + ")", ex);
                }
            }
            catch (NullPointerException ex) {
                if (!warning) break block4;
                this.warning("Could not find boolean parameter " + key + ". Osmose assumes it is false.");
            }
        }
        return false;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, true);
    }

    public int[] getArrayInt(String key) {
        String[] as = this.getArrayString(key);
        try {
            int[] ai = new int[as.length];
            for (int i = 0; i < ai.length; ++i) {
                ai[i] = Integer.valueOf(as[i]);
            }
            return ai;
        }
        catch (NumberFormatException ex) {
            this.error("Could not convert parameter " + key + " to array of integer " + this.getString(key) + " (from file " + this.getSource(key) + ")", ex);
            return null;
        }
    }

    public float[] getArrayFloat(String key) {
        String[] as = this.getArrayString(key);
        try {
            float[] af = new float[as.length];
            for (int i = 0; i < af.length; ++i) {
                af[i] = Float.valueOf(as[i]).floatValue();
            }
            return af;
        }
        catch (NumberFormatException ex) {
            this.error("Could not convert parameter " + key + " to array of float " + this.getString(key) + " (from file " + this.getSource(key) + ")", ex);
            return null;
        }
    }

    public double[] getArrayDouble(String key) {
        String[] as = this.getArrayString(key);
        try {
            double[] ad = new double[as.length];
            for (int i = 0; i < ad.length; ++i) {
                ad[i] = Double.valueOf(as[i]);
            }
            return ad;
        }
        catch (NumberFormatException ex) {
            this.error("Could not convert parameter " + key + " to array of double " + this.getString(key) + " (from file " + this.getSource(key) + ")", ex);
            return null;
        }
    }

    private String resolvePath(String path) {
        String pathname = this.resolveFile(path);
        if (!pathname.endsWith(File.separator)) {
            pathname = pathname + File.separator;
        }
        return pathname;
    }

    private String resolveFile(String filename) {
        try {
            File file = new File(this.inputPathname);
            String pathname = new File(file.toURI().resolve(filename)).getCanonicalPath();
            return pathname;
        }
        catch (Exception ex) {
            return filename;
        }
    }

    public String getOutputPathname() {
        return this.outputPathname;
    }

    public String getOutputSeparator() {
        return this.outputSeparator;
    }

    public String getDefaultSeparator() {
        return this.defaultSeparator.toString();
    }

    public int getNCpu() {
        return this.nCpu;
    }

    public int getNSpecies() {
        return this.nSpecies;
    }

    public int getNPlankton() {
        return this.nPlankton;
    }

    public int getNSimulation() {
        return this.nSimulation;
    }

    public int getNYear() {
        return this.nYear;
    }

    public int getNStepYear() {
        return this.nStepYear;
    }

    public int getNSchool(int iSpecies) {
        return this.nSchool[iSpecies];
    }

    public IGrid getGrid() {
        return this.grid;
    }

    private Separator guessDefaultSeparator() {
        StringBuilder sbSeparators = new StringBuilder();
        for (Parameter parameter : this.parameters) {
            sbSeparators.append(parameter.keySeparator);
        }
        String separators = sbSeparators.toString();
        Separator defaultSep = Separator.EQUALS;
        int nSep1 = 0;
        for (Separator separator : Separator.values()) {
            int nSep2 = separators.length() - separators.replaceAll(separator.toString(), "").length();
            if (nSep2 <= nSep1) continue;
            nSep1 = nSep2;
            defaultSep = separator;
        }
        return defaultSep;
    }

    public String getMainFile() {
        return this.mainFilename;
    }

    private class Parameter {
        private final String source;
        private final int iline;
        private String key;
        private String value;
        private String keySeparator;
        private String valueSeparator;

        Parameter(String line, int iline, String source) {
            this.iline = iline;
            this.source = source;
            this.parse(line);
            Configuration.this.debug(this.key + "=" + this.value);
        }

        private void parse(String line) {
            this.value = null;
            this.key = null;
            this.keySeparator = Separator.guess(line, Separator.EQUALS).toString();
            this.split(line);
            this.valueSeparator = Separator.guess(this.value, Separator.SEMICOLON).toString();
            this.value = this.clean(this.value);
        }

        private String clean(String value) {
            String cleanedValue = value.trim();
            if (cleanedValue.endsWith(this.valueSeparator)) {
                cleanedValue = cleanedValue.substring(0, cleanedValue.lastIndexOf(this.valueSeparator));
                return this.clean(cleanedValue);
            }
            return cleanedValue;
        }

        private void split(String line) {
            if (!line.contains(this.keySeparator)) {
                Configuration.this.error("Failed to split line " + this.iline + " " + line + " as key" + this.keySeparator + "value (from file " + this.source + ")", null);
            }
            this.key = line.substring(0, line.indexOf(this.keySeparator)).toLowerCase().trim();
            try {
                this.value = line.substring(line.indexOf(this.keySeparator) + 1).trim();
            }
            catch (StringIndexOutOfBoundsException ex) {
                this.value = "null";
            }
            if (this.value.isEmpty()) {
                this.value = "null";
            }
            if (this.value.equalsIgnoreCase("null")) {
                Configuration.this.debug("No value found for parameter {0}", this.key);
            }
        }
    }
}

