/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;

public class Dimension
implements Comparable {
    public static Dimension VLEN = new Dimension("*", -1, true, false, true).setImmutable();
    private boolean isUnlimited = false;
    private boolean isVariableLength = false;
    private boolean isShared = true;
    private String name;
    private int length;
    private boolean immutable = false;
    private Group g;
    private int hashCode = 0;

    public static String makeDimensionList(List<Dimension> dimList) {
        StringBuilder out = new StringBuilder();
        for (Dimension dim : dimList) {
            out.append(dim.getName()).append(" ");
        }
        return out.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUnlimited() {
        return this.isUnlimited;
    }

    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public Group getGroup() {
        return this.g;
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Dimension)) {
            return false;
        }
        Dimension other = (Dimension)oo;
        if (this.g != null && !this.g.equals(other.getGroup())) {
            return false;
        }
        if (this.getName() == null && other.getName() != null) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(other.getName())) {
            return false;
        }
        return this.getLength() == other.getLength() && this.isUnlimited() == other.isUnlimited() && this.isVariableLength() == other.isVariableLength() && this.isShared() == other.isShared();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.g != null) {
                result += 37 * result + this.g.hashCode();
            }
            if (null != this.getName()) {
                result += 37 * result + this.getName().hashCode();
            }
            result += 37 * result + this.getLength();
            result += 37 * result + (this.isUnlimited() ? 0 : 1);
            result += 37 * result + (this.isVariableLength() ? 0 : 1);
            result += 37 * result + (this.isShared() ? 0 : 1);
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.writeCDL(false);
    }

    public int compareTo(Object o) {
        Dimension odim = (Dimension)o;
        return this.name.compareTo(odim.getName());
    }

    public String writeCDL(boolean strict) {
        StringBuilder buff = new StringBuilder();
        String name = strict ? NetcdfFile.escapeName(this.getName()) : this.getName();
        buff.append("   ").append(name);
        if (this.isUnlimited()) {
            buff.append(" = UNLIMITED;   // (").append(this.getLength()).append(" currently)");
        } else if (this.isVariableLength()) {
            buff.append(" = UNKNOWN;");
        } else {
            buff.append(" = ").append(this.getLength()).append(";");
        }
        return buff.toString();
    }

    public Dimension(String name, int length) {
        this(name, length, true, false, false);
    }

    public Dimension(String name, int length, boolean isShared) {
        this(name, length, isShared, false, false);
    }

    public Dimension(String name, int length, boolean isShared, boolean isUnlimited, boolean isVariableLength) {
        this.setName(name);
        this.isShared = isShared;
        this.isUnlimited = isUnlimited;
        this.isVariableLength = isVariableLength;
        this.setLength(length);
        assert (this.name != null || !this.isShared);
    }

    public Dimension(String name, Dimension from) {
        this.setName(name);
        this.length = from.length;
        this.isUnlimited = from.isUnlimited;
        this.isVariableLength = from.isVariableLength;
        this.isShared = from.isShared;
    }

    public void setUnlimited(boolean b) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.isUnlimited = b;
        this.setLength(this.length);
    }

    public void setVariableLength(boolean b) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.isVariableLength = b;
        this.setLength(this.length);
    }

    public void setShared(boolean b) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.isShared = b;
        this.hashCode = 0;
    }

    public void setLength(int n) {
        if (this.immutable && !this.isUnlimited) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.isVariableLength) {
            if (n != -1) {
                throw new IllegalArgumentException("VariableLength Dimension length =" + n + " must be -1");
            }
        } else if (this.isUnlimited) {
            if (n < 0) {
                throw new IllegalArgumentException("Unlimited Dimension length =" + n + " must >= 0");
            }
        } else if (n < 1) {
            throw new IllegalArgumentException("Dimension length =" + n + " must be > 0");
        }
        this.length = n;
        this.hashCode = 0;
    }

    public void setName(String name) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.name = name == null || name.length() == 0 ? null : AbstractIOServiceProvider.createValidNetcdfObjectName(name);
        this.hashCode = 0;
    }

    public void setGroup(Group g) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.g = g;
        this.hashCode = 0;
    }

    public Dimension setImmutable() {
        this.immutable = true;
        return this;
    }

    public synchronized void addCoordinateVariable(Variable v) {
    }

    public List<Variable> getCoordinateVariables() {
        return new ArrayList<Variable>();
    }
}

