% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_results.R
\name{combine_results}
\alias{combine_results}
\title{Combine Results from Different Folds}
\usage{
combine_results(results, combiners = NULL, smart_combiners = TRUE)
}
\arguments{
\item{results}{A \code{list} of \code{list}s, corresponding to each result,
with the inner \code{list}s corresponding to results from each fold.}

\item{combiners}{A \code{list} with the same names as results, containing
combiner function names or functions for each result.}

\item{smart_combiners}{A \code{logical} indicating whether combiners should
be guessed from the data type of the results if they are missing.}
}
\value{
A list of combined results.
}
\description{
Applies \code{\link{Combiners}}: functions that collapse across a list of
similarly structured results, to a list of such lists.
}
\details{
In theory you should never call this function directly, because it
 is called automatically by cross_validate. The defaults, combiners guessed
 based on data type, should work in most cases.
}
\seealso{
\code{\link{Combiners}}
}
