\name{flexbeta}
\alias{flexbeta}

\title{Calculate a Flexible-Beta Dendrogram}

\description{Calculates Lance and Williams flexible-beta dendrogram with simplified argument}

\usage{
flexbeta(dis,beta=-0.25,alpha=(1-beta)/2,gamma=0)
}

\arguments{
\item{dis}{a distance or dissimilarity object of class \sQuote{dist}}
\item{beta}{the Beta coefficient}
\item{alpha}{the Alpha coefficients (assumed equal)}
\item{gamma}{the gamma coefficient}
}

\details{
Calculates a flexible-beta dendrogram from a dissimilarity matrix specifying
minimum parameters.  The routine is simply a wrapper for the 
\code{\link[cluster]{agnes}} function from package cluster 
with suitable arguments specified to
achieve desired results.  Ecologist in particular (but many others) find beta = -0.25 
a good default.}

\value{
An object of class \sQuote{hclust} for plotting and analysis like other
hclust objects, as compared to objects of class \sQuote{agnes} as generated by the 
\code{\link[cluster]{agnes}} function in package cluster.}


\references{
Lance, G.N., and W.T. Williams (1966).  A General Theory of
Classifactory Sorting Strategies, I. Hierarchical Systems.
Computer J. *9*, 373-380.}

\seealso{\code{\link[cluster]{agnes}}}


\author{
for the agnes function, Peter Rousseeuw for the original Fortran,
Martin Maechler  for the R code

for this function, David W. Roberts 
\email{droberts@montana.edu}
}

\examples{
data(shoshveg)
dis.bc <- dsvdis(shoshveg,'bray')
flexb <- flexbeta(dis.bc)
}

\keyword{cluster}




