% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasible.R
\name{setMaxProblemSize}
\alias{setMaxProblemSize}
\title{Set the maximum problem size}
\usage{
setMaxProblemSize(size = Inf)
}
\arguments{
\item{size}{Positive integer, or \code{Inf}}
}
\description{
Helper function to ease setting the largest problem size to be
accepted by \code{pairmatch} or \code{fullmatch}.
}
\details{
The function sets the optmatch_max_problem_size global option. The
option ships with the option pre-set to a value that's relatively small,
smaller than what most modern computers can handle.  Invoking this
function with no argument
re-sets the optmatch_max_problem_size option to \code{Inf}, effectively
disabling checks on problem size.  Unless you're working with an older
computer, it probably makes sense for most users to do this, at least
until they determine what problem sizes are too large for their machines.
(You'll know that when your R crashes, or simply takes too long for
your taste.)

To determine the size of a problem without subproblems, i.e. exact
matching categories, use \code{\link{match_on}} to set up and store
the problem distance, then apply \code{length} to the result. If
there were exact matching constraints imposed during the creation
of the distance, then you'll want to look at the largest size of a
subproblem.  Apply \code{\link{findSubproblems}} to your distance,
creating a list, say \code{dlist}, of your distances; then do
\code{sapply(dlist, length)} to determine the sizes of the subproblems.
}
\seealso{
\code{\link{getMaxProblemSize}}
}
\author{
Ben B. Hansen
}
