# Copyright (C) 2008-2009 - INRIA - Michael Baudin
# Copyright (C) 2009-2010 - DIGITEO - Michael Baudin
# Copyright (C) 2010 - Sebastien Bihorel
#
# This file must be used under the terms of the CeCILL.
# This source file is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at
# http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
#
# This source code is a R port of the optimbase component
# originally written by Michael Baudin for Scilab.

vec2matrix <- function(object=NULL){

  if (is.null(object))
    stop('vec2matrix: input is not a matrix or a vector.',
         call.=FALSE)
  if (!is.matrix(object)){
    if (is.vector(object)){
      mat <- matrix(object,ncol=length(object),byrow=TRUE)
    } else {
      stop('vec2matrix: input is not a matrix or a vector.',
           call.=FALSE)
    }
  } else {
    mat <- object
  }
  return(mat)
}

