% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimParallel.R
\docType{package}
\name{optimParallel}
\alias{optimParallel}
\alias{optimparallel}
\alias{optimParallel-package}
\alias{optimParallel-Package}
\alias{OptimParallel-package}
\alias{OptimParallel-Package}
\alias{optimparallel-package}
\alias{optimparallel-Package}
\alias{optimParallel-package}
\title{parallel version of \code{\link[stats]{optim}}}
\usage{
optimParallel(par, fn, gr = NULL, ..., method = c("BFGS", "L-BFGS-B", "CG"),
  lower = -Inf, upper = Inf, control = list(), hessian = FALSE,
  parallel = list())
}
\arguments{
\item{par}{see the documentation of \code{\link[stats]{optim}}.}

\item{fn}{see the documentation of \code{\link[stats]{optim}}.}

\item{gr}{see the documentation of \code{\link[stats]{optim}}.}

\item{...}{see the documentation of \code{\link[stats]{optim}}.
Note that depending on the chosen cluster type, \code{fn} and \code{gr} have no access to \code{.GlobalEnv}.
Hence, all object required by \code{fn} and \code{gr} have to be added here.}

\item{method}{parallel versions of the gradient-based methods \code{"L-BFGS-B"}, \code{"BFGS"}, and \code{"CG"} of \code{\link[stats]{optim}} are available.
See the documentation of \code{\link[stats]{optim}}.
If another method is specified, the arguments are directly passed to \code{\link[stats]{optim}}.}

\item{lower}{see the documentation of \code{\link[stats]{optim}}.}

\item{upper}{see the documentation of \code{\link[stats]{optim}}.}

\item{control}{see the documentation of \code{\link[stats]{optim}}.}

\item{hessian}{see the documentation of \code{\link[stats]{optim}}.}

\item{parallel}{is a list of additional control parameters and can supply any of the following components:
\describe{
\item{\code{cl}}{ an object of class \code{"cluster"} specifying the cluster to be used for parallel execution.
See \code{\link[parallel]{makeCluster}} for more information.
If the argument is not specified or \code{NULL}, the default cluster is used.
See \code{\link[parallel]{setDefaultCluster}} for information on how to set up a default cluster.} 
 \item{\code{forward}}{ logical vector of length 1. If \code{FALSE} (default when loading the package), a numeric central difference approximation of the gradient defined as
\eqn{(fn(x+\epsilon)-fn(x-\epsilon))/(2\epsilon)} is used, which corresponds to the approximation used in \code{\link[stats]{optim}}.
If \code{TRUE}, a nummeric forward difference approximation of the gradient essentially defined as
\eqn{(fn(x+\epsilon)-fn(x))/\epsilon} is used. This reduces the number of function calls from \eqn{1+2p} to \eqn{1+p} and can be useful, if the number of available cores is smaller than \eqn{1+2p}.}
\item{\code{loginfo}}{ logical vector of length 1 with default value \code{FALSE} when loading the package. If \code{TRUE},
additional log information containing the evaluated parameters as well as return the values of \code{fn} and \code{gr} is returned.}
}}
}
\value{
Same as \code{\link[stats]{optim}}. See the documentation thereof.\cr
If a gradient-based method is specified and \code{parallel=list(loginfo=TRUE)}, additional log information containing the evaluated parameters as well as
the return values of \code{fn} and \code{gr} is returned.
}
\description{
The function provides parallel versions of the gradient-based \code{\link[stats]{optim}} methods
\code{"L-BFGS-B"}, \code{"BFGS"}, and \code{"CG"}.
If the evaluation of the function \code{fn} takes more than 0.05 seconds, \code{optimParallel} can significantly reduce the optimization time. 
For a \eqn{p}-parameter optimization based on \code{"L-BFGS-B"}, the speed increase is about factor \eqn{1+2p} when no analytic gradient is specified and \eqn{1+2p} processor cores are available.
}
\details{
\code{optimParallel} is a wrapper to \code{\link[stats]{optim}} and relies on the lexical scoping mechanism of R
and the R package \pkg{parallel} to evaluate \code{fn}
and its (approximate) gradient in parallel.\cr\cr
Some default values of the argument \code{parallel} can be set via\cr\code{options("optimParallel.forward", "optimParallel.loginfo")}.
}
\examples{
negll <- function(par, x, sleep=0, verbose=TRUE){
    if(verbose)
        cat(par, "\\n")
   Sys.sleep(sleep)
   -sum(dnorm(x=x, mean=par[1], sd=par[2], log=TRUE))
}
set.seed(13); x <- rnorm(1000, 5, 2)

cl <- makeCluster(2)     # set the number of processor cores
setDefaultCluster(cl=cl) # set 'cl' as default cluster

optimParallel(par=c(1,1), fn=negll, x=x,
              method = "L-BFGS-B", lower=c(-Inf, .0001))

optimParallel(par=c(1,1), fn=negll, x=x,
              method = "L-BFGS-B", lower=c(-Inf, .0001),
              parallel=list(loginfo=TRUE))

setDefaultCluster(cl=NULL); stopCluster(cl)

## default values of the argument 'parallel':
options("optimParallel.forward", "optimParallel.loginfo")

\dontrun{
## - use all avilable processor cores
## - return cat() output to R prompt
##   (may have issues on Windows)
if(tolower(.Platform$OS.type) != "windows"){
    cl <- makeCluster(spec=detectCores(), type="FORK", outfile="")  
} else
    cl <- makeCluster(spec=detectCores(), outfile="")
setDefaultCluster(cl=cl)

## return log information
options(optimParallel.loginfo=TRUE)              

## stop if change of f(x) is smaller than 0.01
control <- list(factr=.01/.Machine$double.eps)

optimParallel(par=c(1,1), fn=negll, x=x, sleep=.5,
              verbose=TRUE, method="L-BFGS-B",
              lower=c(-Inf, .0001), control=control)
## each step invokes 5 parallel calls to negll()

optimParallel(par=c(1,1), fn=negll, x=x, sleep=.5,
              method ="L-BFGS-B", lower=c(-Inf, .0001),
              control=control,
              parallel=list(forward=TRUE))
## each step invokes 3 parallel calls to negll()

setDefaultCluster(cl=NULL); stopCluster(cl) }
}
\references{
F. Gerber, R. Furrer (2018)
optimParallel: an R Package Providing Parallel Versions of the Gradient-Based Optimization Methods of optim(). 
ArXiv e-prints. URL http://arxiv.org/abs/1804.11058.
Also available as vignette of this package \code{vignette("optimParallel")}.
}
\seealso{
\code{\link[stats]{optim}},
\code{\link[parallel]{makeCluster}},
\code{\link[parallel]{setDefaultCluster}},
\code{\link[parallel]{stopCluster}},
\code{\link[parallel]{detectCores}}.
}
\author{
Florian Gerber, \email{florian.gerber@math.uzh.ch}, \url{https://user.math.uzh.ch/gerber}.
}
\keyword{package}
