% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opticskxi_pipeline.R
\name{opticskxi_pipeline}
\alias{opticskxi_pipeline}
\title{OPTICS k-Xi models comparison pipeline}
\usage{
opticskxi_pipeline(
  m_data,
  df_params = expand.grid(n_xi = 1:10, pts = c(20, 30, 40), dist = c("euclidean",
    "abscorrelation"), dim_red = c("identity", "PCA", "ICA"), n_dimred_comp = c(5, 10,
    20)),
  metrics_dist = c("euclidean", "cosine"),
  max_size_ratio = 1,
  n_min_clusters = 0,
  n_cores = 1,
  ...
)
}
\arguments{
\item{m_data}{Data matrix}

\item{df_params}{Parameter grid for the OPTICS k-Xi function call and
optional dimension reduction.
Required columns: n_xi, pts, dist.
Optonal columns: dim_red, n_dim_red.}

\item{metrics_dist}{Distance used for metrics, either euclidean or cosine.}

\item{max_size_ratio}{Maximum size ratio of clusters.
E.g. for 0.8, if a cluster is larger than 80\% of
points it will be removed.}

\item{n_min_clusters}{Minimum number of clusters. Ignored if 0.}

\item{n_cores}{Number of cores}

\item{...}{Passed to get_kxi_metrics}
}
\value{
Input parameter data frame with with results binded in columns
        optics, clusters and metrics.
}
\description{
Computes OPTICS k-Xi models based on a parameter grid, binds results in a
data frame, and computes distance based metrics for each model.
}
\examples{

data('hla')
m_hla <- hla[-c(1:2)] \%>\% scale

df_params_hla <- expand.grid(n_xi = 3:5, pts = c(20, 30),
  dist = c('manhattan', 'euclidean'))

df_kxi_hla <- opticskxi_pipeline(m_hla, df_params_hla)

ggplot_kxi_metrics(df_kxi_hla, n = 8)
gtable_kxi_profiles(df_kxi_hla) \%>\% plot

best_kxi_hla <- get_best_kxi(df_kxi_hla, rank = 2)
clusters_hla <- best_kxi_hla$clusters

fortify_pca(m_hla, sup_vars = data.frame(Clusters = clusters_hla)) \%>\%
  ggpairs('Clusters', ellipses = TRUE, variables = TRUE)

}
\seealso{
\link{get_best_kxi}, \link{ggplot_kxi_metrics},
\link{gtable_kxi_profiles}
}
