% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_slicer}
\alias{wb_add_slicer}
\title{Add a slicer to a pivot table}
\usage{
wb_add_slicer(
  wb,
  x,
  dims = "A1",
  sheet = current_sheet(),
  pivot_table,
  slicer,
  params
)
}
\arguments{
\item{wb}{A Workbook object containing a #' worksheet.}

\item{x}{A \code{data.frame} that inherits the \code{\link[=wb_data]{wb_data}} class.}

\item{dims}{The worksheet cell where the pivot table is placed}

\item{sheet}{A worksheet containing a #'}

\item{pivot_table}{the name of a pivot table on the selected sheet}

\item{slicer}{a variable used as slicer for the pivot table}

\item{params}{a list of parameters to modify pivot table creation}
}
\description{
Add a slicer to a previously created pivot table. This function is still experimental and might be changed/improved in upcoming releases.
}
\details{
This assumes that the slicer variable initialization has happened before. Unfortunately, it is unlikely that we can guarantee this for loaded workbooks, and we \emph{strictly} discourage users from attempting this. If the variable has not been initialized properly, this may cause the spreadsheet software to crash.

For the time being, the slicer needs to be placed on the slide with the pivot table.
}
\examples{
wb <- wb_workbook() \%>\%
  wb_add_worksheet() \%>\% wb_add_data(x = mtcars)

df <- wb_data(wb, sheet = 1)

wb <- wb \%>\%
  wb_add_pivot_table(
    df, dims = "A3", slicer = "vs", rows = "cyl", cols = "gear", data = "disp",
    pivot_table = "mtcars"
  ) \%>\%
  wb_add_slicer(x = df, slicer = "vs", pivot_table = "mtcars")
}
\seealso{
Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}

Other worksheet content functions: 
\code{\link{col_widths-wb}},
\code{\link{filter-wb}},
\code{\link{grouping-wb}},
\code{\link{named_region-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_conditional_formatting}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_thread}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()}
}
\concept{workbook wrappers}
\concept{worksheet content functions}
