% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_formula}
\alias{wb_add_formula}
\title{Add a character vector as an Excel Formula}
\usage{
wb_add_formula(
  wb,
  sheet = current_sheet(),
  x,
  startCol = 1,
  startRow = 1,
  dims = rowcol_to_dims(startRow, startCol),
  array = FALSE,
  xy = NULL
)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{A character vector.}

\item{startCol}{A vector specifying the starting column to write to.}

\item{startRow}{A vector specifying the starting row to write to.}

\item{dims}{Spreadsheet dimensions that will determine startCol and startRow: "A1", "A1:B2", "A:B"}

\item{array}{A bool if the function written is of type array}

\item{xy}{An alternative to specifying \code{startCol} and
\code{startRow} individually.  A vector of the form
\code{c(startCol, startRow)}.}
}
\description{
Add a character vector containing Excel formula to a worksheet.
}
\details{
Currently only the English version of functions are supported. Please don't use the local translation.
The examples below show a small list of possible formulas:
\itemize{
\item{SUM(B2:B4)}
\item{AVERAGE(B2:B4)}
\item{MIN(B2:B4)}
\item{MAX(B2:B4)}
\item{...}

}
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_get_base_font}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
