#' Major League Baseball Teams Data.
#'
#' A subset of data on Major League Baseball teams from
#' Lahman's Baseball Database. The full data set is available
#' in the [Lahman R package](https://github.com/cdalzell/Lahman).
#'
#' @name mlb_teams
#' @docType data
#' @format A data frame with 2784 rows and 41 variables.
#' \describe{
#'   \item{year}{Year of play.}
#'   \item{league_id}{League the team plays in with levels AL (American League) and NL (National League).}
#'   \item{division_id}{Division the team plays in with levels W (west), E (east) and C (central).}
#'   \item{rank}{Team's rank in their division at the end of the regular season.}
#'   \item{games_played}{Games played.}
#'   \item{home_games}{Games played at home.}
#'   \item{wins}{Number of games won.}
#'   \item{losses}{Number of games lost.}
#'   \item{division_winner}{Did the team win their division? Levels of Y (yes) and N (no).}
#'   \item{wild_card_winner}{Was the team a wild card winner. Levels of Y (yes) and N (no).}
#'   \item{league_winner}{Did the team win their league? Levels of Y (yes) and N (no).}
#'   \item{world_series_winner}{Did the team win the World Series? Levels of Y (yes) and N (no).}
#'   \item{runs_scored}{Number of runs scored during the season.}
#'   \item{at_bats}{Number of at bats during the season.}
#'   \item{hits}{Number of hits during the season. Includes singles, doubles, triples and homeruns.}
#'   \item{doubles}{Number of doubles hit.}
#'   \item{triples}{Number of triples hit.}
#'   \item{homeruns}{Homeruns by batters.}
#'   \item{walks}{Number of walks.}
#'   \item{strikeouts_by_batters}{Number of batters struckout.}
#'   \item{stolen_bases}{Number of stolen bases.}
#'   \item{caught_stealing}{Number of base runners caught stealing.}
#'   \item{batters_hit_by_pitch}{Number of batters hit by a pitch.}
#'   \item{sacrifice_flies}{Number of sacrifice flies.}
#'   \item{opponents_runs_scored}{Number of runs scored by opponents.}
#'   \item{earned_runs_allowed}{Number of earned runs allowed.}
#'   \item{earned_run_average}{Earned run average.}
#'   \item{complete_games}{Number of games where a single pitcher played the entire game.}
#'   \item{shutouts}{Number of shutouts.}
#'   \item{saves}{Number of saves.}
#'   \item{outs_pitches}{Number of outs pitched for the season (number of innings pitched times 3).}
#'   \item{hits_allowed}{Number of hits made by opponents.}
#'   \item{homeruns_allowed}{Number of homeruns hit by opponents.}
#'   \item{walks_allowed}{Number of opponents who were walked.}
#'   \item{strikeouts_by_pitchers}{Number of opponents who were struckout.}
#'   \item{errors}{Number of errors.}
#'   \item{double_plays}{Number of double plays.}
#'   \item{fielding_percentage}{Teams fielding  percentage.}
#'   \item{team_name}{Full name of team.}
#'   \item{ball_park}{Home ballpark name.}
#'   \item{home_attendance}{Home attendance total.}
#'   }
#' @examples
#' library(dplyr)
#'
#' # List the World Series winning teams for each year
#' mlb_teams %>%
#'   filter(world_series_winner == "Y") %>%
#'   select(year, team_name, ball_park)
#'
#' # List the teams with their average number of wins and losses
#' mlb_teams %>%
#'   group_by(team_name) %>%
#'   summarize(mean_wins = mean(wins), mean_losses = mean(losses)) %>%
#'   arrange((team_name))
#' @source [Lahmans Baseball Database](https://www.seanlahman.com/baseball-archive/statistics/)
#' @keywords datasets
#'
"mlb_teams"
