% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polarDiff.R
\name{polarDiff}
\alias{polarDiff}
\title{Polar plots considering changes in concentrations between two time periods}
\usage{
polarDiff(
  before,
  after,
  pollutant = "nox",
  x = "ws",
  limits = NA,
  plot = TRUE,
  ...
)
}
\arguments{
\item{before}{A data frame that represents the "before" case. See
\code{\link{polarPlot}} for details of different input requirements.}

\item{after}{A data frame that represents the "after" case. See
\code{\link{polarPlot}} for details of different input requirements.}

\item{pollutant}{The pollutant to analyse.}

\item{x}{The variable used for the radial axis (default = "ws").}

\item{limits}{The colour scale limits e.g. \code{limits = c(-10, 10)}.}

\item{plot}{Should a plot be produced? \code{FALSE} can be useful when
analysing data to extract plot components and plotting them in other
ways.}

\item{...}{Other arguments to \code{\link{polarPlot}}.}
}
\value{
Only plot at the moment.
}
\description{
This function provides a way of showing the differences in concentrations
between two time periods as a polar plot. There are several uses of this
function, but the most common will be to see how source(s) may have changed
between two periods.
}
\details{
While the function is primarily intended to compare two time periods at the
same location, it can be used for any two data sets that contain the same
pollutant. For example, data from two sites that are close to one another, or
two co-located instruments.

The analysis works by calculating the polar plot surface for the
\code{before} and \code{after} periods and then subtracting the \code{before}
surface from the \code{after} surface.
}
\examples{

\dontrun{

before_data <- selectByDate(mydata, year = 2002)
after_data <- selectByDate(mydata, year = 2003)

polarDiff(before_data, after_data, pollutant = "no2")

# with some options
polarDiff(before_data, after_data, pollutant = "no2", cols = "RdYlBu", limits = c(-20, 20))

}
}
