% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_data}
\alias{import_data}
\title{Import data into 'GRASS.'}
\usage{
import_data(dem, band = 1, sites, streams = NULL, snap_streams = FALSE,
  pred_sites = NULL, predictor_maps = NULL, predictor_names = NULL)
}
\arguments{
\item{dem}{character; path to DEM raster file.}

\item{band}{integer (optional); defines which band is used}

\item{sites}{character string or object; path to sites vector file (shape) 
or sp data object.}

\item{streams}{character string or object (optional); path to network vector 
file (shape) or sp data object.
 If available it can be burnt into DEM.}

\item{snap_streams}{boolean (optional); snap line ends.
If TRUE line ends of the streams are snapped to the next feature if they are
 unconnected with threshold of 10 m using 'GRASS' function v.clean.}

\item{pred_sites}{character vector (optional); paths to prediction sites 
vector files}

\item{predictor_maps}{character vector (optional); paths to raster data to 
import as predictors.}

\item{predictor_names}{character vector (optional); names for potential predictor
variables.}
}
\value{
Nothing, the data is loaded into the 'GRASS' session (mapset PERMANENT).
The DEM is stored as raster 'dem', sites as vector 'sites_o', prediction sites
vector(s) using the original file names with an appended '_o' (without extension),
streams as vector 'streams_o' in the 'GRASS' location. Additionally, predictor 
map raster(s) can be read in and are stored in 'GRASS' using either the 
original file names (without extension) or using the names provides in 
predictor_names. The latter option may be useful if ArcGIS grid data 
(typically stored as 'grid_name/w001001.adf') are used.
.
}
\description{
This function loads dem and sites data (both required) into the 'GRASS' session.
Optionally, prediction sites and streams data can be loaded and the streams 
may be corrected by snapping to prevent lose ends.
}
\note{
A GRASS session must be initiated before, see \code{\link[rgrass7]{initGRASS}}.
}
\examples{
\donttest{
# Initiate GRASS session
if(.Platform$OS.type == "windows"){
  gisbase = "c:/Program Files/GRASS GIS 7.2.0"
  } else {
  gisbase = "/usr/lib/grass72/"
  }
initGRASS(gisBase = gisbase,
    home = tempdir(),
    override = TRUE)

dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
setup_grass_environment(dem = dem_path, sites = sites_path)
import_data(dem = dem_path, sites = sites_path)
gmeta()
dem <- readRAST('dem')
plot(dem)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com},  Mira Kattwinkel
 \email{mira.kattwinkel@gmx.net}
}
