% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_streams.R
\name{derive_streams}
\alias{derive_streams}
\title{Derive stream network from DEM.}
\usage{
derive_streams(burn = 5, accum_threshold = 700, condition = TRUE,
  min_stream_length = 0, dem_name = NULL, clean = TRUE, mem = FALSE)
}
\arguments{
\item{burn}{numeric; how many meters should the streams be burned into the
DEM?}

\item{accum_threshold}{integer; accumulation threshold to use (i.e. minimum
flow accumulation value in cells that will initiate a new stream).}

\item{condition}{logical; should the DEM be conditioned using
\href{https://grass.osgeo.org/grass70/manuals/addons/r.hydrodem.html}{r.hydrodem}?#'}

\item{min_stream_length}{integer: minimum stream length in number of DEM
raster cells; shorter first order stream segments are deleted; default: 0}

\item{dem_name}{character vector, optional; default: 'dem'; useful if
conditioned and / or burnt in DEM raster from previous runs shall be used.}

\item{clean}{logical; should intermediate raster layer of imported streams
('streams_or') be removed from 'GRASS' session?}

\item{mem}{logical; should -m flag in GRASS r.watershed be used (as indicated in its help)
see also \code{\link{watershed_memory}}-function}
}
\value{
Nothing. The function produces the following maps:
\itemize{
 \item{'streams_r'} {derived streams (raster)}
 \item{'streams_v'} {derived streams with topology (vector)}
 \item{'dirs'} {flow directions (raster)}
 \item{'accums'} {accumulation values (raster)}
 \item{'dem_cond'} {conditioned dem (raster) if  \code{condition} is TRUE}
 \item{'dem_[cond]_burn[X]'} {burnt in DEM (raster) if burn is > 0}
} The original GRASS map 'dem' is not modified if \code{condition} is TRUE and / or \code{burn} > 0.
}
\description{
Streams are derived from a digital elevation model (DEM) using
\href{https://grass.osgeo.org/grass70/manuals/r.stream.extract.html}{r.stream.extract}.
If a stream network is available (see \code{\link{import_data}}) and burn > 0
it will be first burnt into the digital elevation model (DEM). Stream
topology is derived using
\href{https://grass.osgeo.org/grass70/manuals/addons/r.stream.order.html}{r.stream.order}.
}
\details{
For details on \code{accum_threshold} and \code{min_stream_length}
see the parameters 'threshold' and 'stream_length' at
\href{https://grass.osgeo.org/grass73/manuals/r.stream.extract}{r.stream.extract}.
It might be useful to not burn in the whole available stream network but only 
parts of it (e.g., larger streams with higher Strahler stream order only). 
For this, the stream network needs to be pre-processed before loading it with 
\code{import_data}.
}
\note{
\code{\link{setup_grass_environment}} and \code{\link{import_data}}
  must be run before.
}
\examples{
\donttest{
# Initiate GRASS session
if(.Platform$OS.type == "windows"){
  gisbase = "c:/Program Files/GRASS GIS 7.2.0"
  } else {
  gisbase = "/usr/lib/grass72/"
  }
initGRASS(gisBase = gisbase,
    home = tempdir(),
    override = TRUE)

# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
setup_grass_environment(dem = dem_path, sites = sites_path)
import_data(dem = dem_path, sites = sites_path)
gmeta()

# Derive streams from DEM
derive_streams(burn = 0, accum_threshold = 700, condition = TRUE, clean = TRUE)
dem <- readRAST('dem', ignore.stderr = TRUE)
sites <- readVECT('sites_o', ignore.stderr = TRUE)
streams <- readVECT('streams_v', ignore.stderr = TRUE)
plot(dem, col = terrain.colors(20))
lines(streams, col = 'blue', lwd = 2)
points(sites, pch = 4)
}

}
\author{
Mira Kattwinkel \email{mira.kattwinkel@gmx.net}, Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
