/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.mention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import opennlp.tools.coref.mention.AbstractParse;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultParse
extends AbstractParse {
    public static String[] NAME_TYPES = new String[]{"person", "organization", "location", "date", "time", "percentage", "money"};
    private opennlp.tools.parser.Parse parse;
    private int sentenceNumber;
    private static Set<String> entitySet = new HashSet<String>(Arrays.asList(NAME_TYPES));

    public DefaultParse(opennlp.tools.parser.Parse parse, int sentenceNumber) {
        this.parse = parse;
        this.sentenceNumber = sentenceNumber;
    }

    @Override
    public int getSentenceNumber() {
        return this.sentenceNumber;
    }

    @Override
    public List<Parse> getNamedEntities() {
        ArrayList<opennlp.tools.parser.Parse> names = new ArrayList<opennlp.tools.parser.Parse>();
        LinkedList<opennlp.tools.parser.Parse> kids = new LinkedList<opennlp.tools.parser.Parse>(Arrays.asList(this.parse.getChildren()));
        while (kids.size() > 0) {
            opennlp.tools.parser.Parse p = (opennlp.tools.parser.Parse)kids.remove(0);
            if (entitySet.contains(p.getType())) {
                names.add(p);
                continue;
            }
            kids.addAll(Arrays.asList(p.getChildren()));
        }
        return this.createParses(names.toArray(new opennlp.tools.parser.Parse[names.size()]));
    }

    @Override
    public List<Parse> getChildren() {
        return this.createParses(this.parse.getChildren());
    }

    @Override
    public List<Parse> getSyntacticChildren() {
        ArrayList<opennlp.tools.parser.Parse> kids = new ArrayList<opennlp.tools.parser.Parse>(Arrays.asList(this.parse.getChildren()));
        for (int ci = 0; ci < kids.size(); ++ci) {
            opennlp.tools.parser.Parse kid = (opennlp.tools.parser.Parse)kids.get(ci);
            if (!entitySet.contains(kid.getType())) continue;
            kids.remove(ci);
            kids.addAll(ci, Arrays.asList(kid.getChildren()));
            --ci;
        }
        return this.createParses(kids.toArray(new opennlp.tools.parser.Parse[kids.size()]));
    }

    @Override
    public List<Parse> getTokens() {
        ArrayList<opennlp.tools.parser.Parse> tokens = new ArrayList<opennlp.tools.parser.Parse>();
        LinkedList<opennlp.tools.parser.Parse> kids = new LinkedList<opennlp.tools.parser.Parse>(Arrays.asList(this.parse.getChildren()));
        while (kids.size() > 0) {
            opennlp.tools.parser.Parse p = (opennlp.tools.parser.Parse)kids.remove(0);
            if (p.isPosTag()) {
                tokens.add(p);
                continue;
            }
            kids.addAll(0, Arrays.asList(p.getChildren()));
        }
        return this.createParses(tokens.toArray(new opennlp.tools.parser.Parse[tokens.size()]));
    }

    @Override
    public String getSyntacticType() {
        if (entitySet.contains(this.parse.getType())) {
            return null;
        }
        if (this.parse.getType().contains("#")) {
            return this.parse.getType().substring(0, this.parse.getType().indexOf(35));
        }
        return this.parse.getType();
    }

    private List<Parse> createParses(opennlp.tools.parser.Parse[] parses) {
        ArrayList<Parse> newParses = new ArrayList<Parse>(parses.length);
        int pn = parses.length;
        for (int pi = 0; pi < pn; ++pi) {
            newParses.add(new DefaultParse(parses[pi], this.sentenceNumber));
        }
        return newParses;
    }

    @Override
    public String getEntityType() {
        if (entitySet.contains(this.parse.getType())) {
            return this.parse.getType();
        }
        return null;
    }

    @Override
    public boolean isParentNAC() {
        for (opennlp.tools.parser.Parse parent = this.parse.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getType().equals("NAC")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Parse getParent() {
        opennlp.tools.parser.Parse parent = this.parse.getParent();
        if (parent == null) {
            return null;
        }
        return new DefaultParse(parent, this.sentenceNumber);
    }

    @Override
    public boolean isNamedEntity() {
        return entitySet.contains(this.parse.getType());
    }

    @Override
    public boolean isNounPhrase() {
        return this.parse.getType().equals("NP") || this.parse.getType().startsWith("NP#");
    }

    @Override
    public boolean isSentence() {
        return this.parse.getType().equals("TOP");
    }

    @Override
    public boolean isToken() {
        return this.parse.isPosTag();
    }

    @Override
    public int getEntityId() {
        String type = this.parse.getType();
        if (type.contains("#")) {
            String numberString = type.substring(type.indexOf(35) + 1);
            return Integer.parseInt(numberString);
        }
        return -1;
    }

    @Override
    public Span getSpan() {
        return this.parse.getSpan();
    }

    @Override
    public int compareTo(Parse p) {
        if (p == this) {
            return 0;
        }
        if (this.getSentenceNumber() < p.getSentenceNumber()) {
            return -1;
        }
        if (this.getSentenceNumber() > p.getSentenceNumber()) {
            return 1;
        }
        if (this.parse.getSpan().getStart() == p.getSpan().getStart() && this.parse.getSpan().getEnd() == p.getSpan().getEnd()) {
            System.out.println("Maybe incorrect measurement!");
            Stack stack = new Stack();
        }
        return this.parse.getSpan().compareTo(p.getSpan());
    }

    @Override
    public String toString() {
        return this.parse.getCoveredText();
    }

    @Override
    public Parse getPreviousToken() {
        opennlp.tools.parser.Parse parent = this.parse.getParent();
        opennlp.tools.parser.Parse node = this.parse;
        int index = -1;
        while (parent != null && index < 0) {
            index = parent.indexOf(node) - 1;
            if (index >= 0) continue;
            node = parent;
            parent = parent.getParent();
        }
        if (index < 0) {
            return null;
        }
        opennlp.tools.parser.Parse p = parent.getChildren()[index];
        while (!p.isPosTag()) {
            opennlp.tools.parser.Parse[] kids = p.getChildren();
            p = kids[kids.length - 1];
        }
        return new DefaultParse(p, this.sentenceNumber);
    }

    @Override
    public Parse getNextToken() {
        opennlp.tools.parser.Parse parent;
        opennlp.tools.parser.Parse node = this.parse;
        int index = -1;
        for (parent = this.parse.getParent(); parent != null && (index = parent.indexOf(node) + 1) == parent.getChildCount(); parent = parent.getParent()) {
            node = parent;
        }
        if (parent == null) {
            return null;
        }
        opennlp.tools.parser.Parse p = parent.getChildren()[index];
        while (!p.isPosTag()) {
            p = p.getChildren()[0];
        }
        return new DefaultParse(p, this.sentenceNumber);
    }

    public boolean equals(Object o) {
        boolean result = o == this ? true : (o instanceof DefaultParse ? this.parse == ((DefaultParse)o).parse : false);
        return result;
    }

    public int hashCode() {
        return this.parse.hashCode();
    }

    public opennlp.tools.parser.Parse getParse() {
        return this.parse;
    }
}

